"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTimerange = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _metrics = require("../../../../../common/alerting/metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTimerange = (interval, aggType, timeframe, lastPeriodEnd) => {
  const end = (0, _moment.default)(timeframe && timeframe.end ? timeframe.end : Date.now()).valueOf();
  const start = (0, _moment.default)(timeframe && timeframe.start ? timeframe.start : end).valueOf();

  // Rate aggregations need 5 buckets worth of data
  const minimumBuckets = aggType === _metrics.Aggregators.RATE ? 2 : 1;
  interval = interval * minimumBuckets;
  let calculatedFrom = end - interval;
  if (lastPeriodEnd && lastPeriodEnd - interval < start) {
    const maxAllowedLookBack = (0, _moment.default)(start).subtract(3 * interval, 'ms');
    // Calculate the maximum allowable look-back time (3 intervals before the current 'from' time).
    if ((0, _moment.default)(lastPeriodEnd).isAfter(maxAllowedLookBack)) {
      // Ensure lastPeriodEnd is within the allowable look-back range.
      calculatedFrom = lastPeriodEnd - interval;
    }
  }
  const from = timeframe && timeframe.start && timeframe.start <= calculatedFrom ? timeframe.start : calculatedFrom;
  return {
    start: from,
    end
  };
};
exports.createTimerange = createTimerange;