"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AwsEC2Layout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _chart_section_vis = require("../chart_section_vis");
var _metadata_details = require("../metadata_details");
var _section = require("../section");
var _sub_section = require("../sub_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/layouts/aws_ec2_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AwsEC2Layout = exports.AwsEC2Layout = (0, _eui.withEuiTheme)(({
  metrics,
  theme,
  onChangeRangeTime
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_metadata_details.MetadataDetails, {
  fields: ['cloud.instance.id', 'cloud.provider', 'cloud.availability_zone', 'cloud.machine.type', 'cloud.instance.name', 'cloud.project.id'],
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_section.Section, {
  navLabel: "AWS EC2",
  sectionLabel: _i18n.i18n.translate('xpack.infra.metricDetailPage.ec2MetricsLayout.overviewSection.sectionLabel', {
    defaultMessage: 'Aws EC2 Overview'
  }),
  metrics: metrics,
  onChangeRangeTime: onChangeRangeTime,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsEC2CpuUtilization",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.ec2MetricsLayout.cpuUsageSection.sectionLabel', {
    defaultMessage: 'CPU Usage'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  stacked: true,
  type: "area",
  formatter: "percent",
  seriesOverrides: {
    total: {
      color: theme.euiTheme.colors.vis.euiColorVis1
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 13
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsEC2NetworkTraffic",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.ec2MetricsLayout.networkTrafficSection.sectionLabel', {
    defaultMessage: 'Network Traffic'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  formatter: "bits",
  formatterTemplate: "{{value}}/s",
  type: "area",
  seriesOverrides: {
    rx: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkRxRateSeriesLabel', {
        defaultMessage: 'in'
      })
    },
    tx: {
      color: theme.euiTheme.colors.vis.euiColorVis2,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkTxRateSeriesLabel', {
        defaultMessage: 'out'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 69,
    columnNumber: 13
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsEC2DiskIOBytes",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.ec2MetricsLayout.diskIOBytesSection.sectionLabel', {
    defaultMessage: 'Disk IO (Bytes)'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  formatter: "bytes",
  formatterTemplate: "{{value}}/s",
  type: "area",
  seriesOverrides: {
    write: {
      color: theme.euiTheme.colors.vis.euiColorVis2,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.ec2MetricsLayout.diskIOBytesSection.writeLabel', {
        defaultMessage: 'writes'
      })
    },
    read: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.ec2MetricsLayout.diskIOBytesSection.readLabel', {
        defaultMessage: 'reads'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 104,
    columnNumber: 13
  }
}))))));