"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewSwitcher = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/view_switcher.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ViewSwitcher = ({
  view,
  onChange
}) => {
  const buttons = [{
    id: 'map',
    label: _i18n.i18n.translate('xpack.infra.viewSwitcher.mapViewLabel', {
      defaultMessage: 'Map view'
    }),
    iconType: 'grid'
  }, {
    id: 'table',
    label: _i18n.i18n.translate('xpack.infra.viewSwitcher.tableViewLabel', {
      defaultMessage: 'Table view'
    }),
    iconType: 'visTable'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.infra.viewSwitcher.lenged', {
      defaultMessage: 'Switch between table and map view'
    }),
    options: buttons,
    color: "text",
    buttonSize: "s",
    idSelected: view,
    onChange: onChange,
    isIconOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
};
exports.ViewSwitcher = ViewSwitcher;