"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionalToolTip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _i18n = require("@kbn/i18n");
var _get_custom_metric_label = require("../../../../../../common/formatters/get_custom_metric_label");
var _metrics_source = require("../../../../../containers/metrics_source");
var _use_snaphot = require("../../hooks/use_snaphot");
var _create_inventory_metric_formatter = require("../../lib/create_inventory_metric_formatter");
var _intl_strings = require("../../../../../../common/inventory_models/intl_strings");
var _use_waffle_options = require("../../hooks/use_waffle_options");
var _create_formatter_for_metric = require("../../../metrics_explorer/components/helpers/create_formatter_for_metric");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/conditional_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConditionalToolTip = ({
  node,
  nodeType,
  currentTime
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  // prevents auto-refresh from cancelling ongoing requests to fetch the data for the tooltip
  const requestCurrentTime = (0, _react.useRef)(currentTime);
  const model = (0, _common.findInventoryModel)(nodeType);
  const {
    customMetrics,
    preferredSchema
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const requestMetrics = model.metrics.getWaffleMapTooltipMetrics({
    schema: preferredSchema !== null && preferredSchema !== void 0 ? preferredSchema : 'ecs'
  }).map(type => ({
    type
  })).concat(customMetrics);
  const {
    nodes,
    loading
  } = (0, _use_snaphot.useSnapshot)({
    kuery: `"${model.fields.id}": ${node.id}`,
    metrics: requestMetrics,
    groupBy: [],
    nodeType,
    sourceId,
    currentTime: requestCurrentTime.current,
    accountId: '',
    region: '',
    schema: preferredSchema
  });
  const dataNode = (0, _lodash.first)(nodes);
  const metrics = dataNode && dataNode.metrics || [];
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: 220
    },
    "data-test-subj": `conditionalTooltipContent-${node.name}`,
    "aria-label": node.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      borderBottom: `${euiTheme.border.thin}`,
      borderBottomColor: `${euiTheme.colors.mediumShade}`,
      paddingBottom: euiTheme.size.xs,
      marginBottom: euiTheme.size.xs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, node.name), loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "conditionalTooltipContent-loading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }))) : metrics.map(metric => {
    const metricName = _common.SnapshotMetricTypeRT.is(metric.name) ? metric.name : 'custom';
    const name = (0, _intl_strings.getSnapshotMetricTranslations)(nodeType)[metricName] || metricName;
    // if custom metric, find field and label from waffleOptionsContext result
    // because useSnapshot does not return it
    const customMetric = name === 'custom' ? customMetrics.find(item => item.id === metric.name) : null;
    const formatter = customMetric ? (0, _create_formatter_for_metric.createFormatterForMetric)(customMetric) : (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
      type: metricName
    });
    const metricAriaLabel = _i18n.i18n.translate('xpack.infra.node.tooltip.ariaLabel', {
      defaultMessage: '{customMetric} : {value}',
      values: {
        customMetric: customMetric ? (0, _get_custom_metric_label.getCustomMetricLabel)(customMetric) : name,
        value: metric.value && formatter(metric.value) || '-'
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      key: metric.name,
      "aria-label": metricAriaLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      className: "eui-textTruncate eui-displayBlock",
      "data-test-subj": "conditionalTooltipContent-metric",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 15
      }
    }, customMetric ? (0, _get_custom_metric_label.getCustomMetricLabel)(customMetric) : name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "conditionalTooltipContent-value",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 15
      }
    }, metric.value && formatter(metric.value) || '-'));
  }));
};
exports.ConditionalToolTip = ConditionalToolTip;