"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_alert_prefill = require("../../../../alerting/use_alert_prefill");
var _metrics_source = require("../../../../containers/metrics_source");
var _use_snaphot = require("../hooks/use_snaphot");
var _use_waffle_filters = require("../hooks/use_waffle_filters");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _use_waffle_time = require("../hooks/use_waffle_time");
var _filter_bar = require("./filter_bar");
var _layout_view = require("./layout_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/snapshot_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SnapshotContainer = exports.SnapshotContainer = /*#__PURE__*/_react.default.memo(() => {
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const {
    metric,
    groupBy,
    nodeType,
    accountId,
    region,
    preferredSchema
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    filterQuery
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const {
    inventoryPrefill
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  (0, _react.useEffect)(() => {
    return () => inventoryPrefill.reset();
  }, [inventoryPrefill]);
  const {
    loading,
    nodes,
    interval = '60s'
  } = (0, _use_snaphot.useSnapshot)({
    kuery: filterQuery.query,
    metrics: [metric],
    groupBy,
    nodeType,
    sourceId,
    currentTime,
    accountId,
    region,
    schema: preferredSchema
  }, {
    sendRequestImmediately: true
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filter_bar.FilterBar, {
    interval: interval,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_layout_view.LayoutView, {
    loading: loading,
    nodes: nodes,
    interval: interval,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }));
});