"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostIpToName = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostIpToName = (ipAddress, indexPattern) => {
  var _useKibana$services$h;
  const fetch = (_useKibana$services$h = (0, _public.useKibana)().services.http) === null || _useKibana$services$h === void 0 ? void 0 : _useKibana$services$h.fetch;
  const [error, setError] = (0, _react.useState)(null);
  const [loading, setLoadingState] = (0, _react.useState)(true);
  const [data, setData] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    (async () => {
      setLoadingState(true);
      setError(null);
      try {
        if (!fetch) {
          throw new Error('HTTP service is unavailable');
        }
        if (ipAddress && indexPattern) {
          const response = await fetch('/api/infra/ip_to_host', {
            method: 'POST',
            body: JSON.stringify({
              ip: ipAddress,
              index_pattern: indexPattern
            })
          });
          setLoadingState(false);
          setData(response);
        }
      } catch (err) {
        setLoadingState(false);
        setError(err);
      }
    })();
  }, [ipAddress, indexPattern, fetch]);
  return {
    name: data && data.host || null,
    loading,
    error
  };
};
exports.useHostIpToName = useHostIpToName;