"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaUiSetting = useKibanaUiSetting;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook behaves like a `useState` hook in that it provides a requested
 * setting value (with an optional default) from the Kibana UI settings (also
 * known as "advanced settings") and a setter to change that setting:
 *
 * ```
 * const [quickRanges, setQuickRanges] = useKibanaUiSetting('timepicker:quickRanges');
 * ```
 *
 * This is not just a static consumption of the value, but will reactively
 * update when the underlying setting subscription of the `UiSettingsClient`
 * notifies of a change.
 *
 * Unlike the `useState`, it doesn't give type guarantees for the value,
 * because the underlying `UiSettingsClient` doesn't support that.
 */

function useKibanaUiSetting(key, defaultValue) {
  const [uiSetting, setUiSetting] = (0, _public.useUiSetting$)(key);
  const uiSettingValue = (0, _react.useMemo)(() => {
    return uiSetting ? uiSetting : defaultValue;
  }, [uiSetting, defaultValue]);
  return [uiSettingValue, setUiSetting];
}