"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSuccess = exports.isPending = exports.isFailure = exports.FETCH_STATUS = void 0;
exports.useFetcher = useFetcher;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _use_kibana = require("./use_kibana");
var _use_reload_request_time = require("./use_reload_request_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/hooks/use_fetcher.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let FETCH_STATUS = exports.FETCH_STATUS = /*#__PURE__*/function (FETCH_STATUS) {
  FETCH_STATUS["LOADING"] = "loading";
  FETCH_STATUS["SUCCESS"] = "success";
  FETCH_STATUS["FAILURE"] = "failure";
  FETCH_STATUS["NOT_INITIATED"] = "not_initiated";
  FETCH_STATUS["PENDING"] = "pending";
  return FETCH_STATUS;
}({});
const isPending = fetchStatus => fetchStatus === FETCH_STATUS.LOADING || fetchStatus === FETCH_STATUS.NOT_INITIATED || fetchStatus === FETCH_STATUS.PENDING;
exports.isPending = isPending;
const isFailure = fetchStatus => fetchStatus === FETCH_STATUS.FAILURE;
exports.isFailure = isFailure;
const isSuccess = fetchStatus => fetchStatus === FETCH_STATUS.SUCCESS;
exports.isSuccess = isSuccess;
function getDetailsFromErrorResponse(error) {
  var _error$response, _error$response2, _error$response3, _error$body;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.infra.useHTTPRequest.error.status', {
    defaultMessage: `Error`
  })), (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.statusText, " (", (_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.status, ")", /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.infra.useHTTPRequest.error.url', {
    defaultMessage: `URL`
  })), (_error$response3 = error.response) === null || _error$response3 === void 0 ? void 0 : _error$response3.url, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.infra.useHTTPRequest.error.body.message', {
    defaultMessage: `Message`
  })), ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || error.message);
}
function createAutoAbortedClient(signal, http) {
  return (path, options) => {
    return http.fetch(path, {
      ...options,
      signal
    }).catch(err => {
      throw err;
    }).then(response => {
      return response;
    });
  };
}
function useFetcher(fn, fnDeps = [], options = {}) {
  const {
    services: {
      http,
      notifications,
      rendering
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    autoFetch = true,
    preservePreviousData = true,
    showToastOnError = true,
    reloadRequestTimeUpdateEnabled = true,
    requestObservable$
  } = options;
  const [result, setResult] = (0, _react.useState)({
    data: undefined,
    status: FETCH_STATUS.NOT_INITIATED
  });
  const {
    reloadRequestTime
  } = (0, _use_reload_request_time.useReloadRequestTimeContext)();
  const [cachedReloadRequestTime, setCachedReloadRequestTime] = (0, _react.useState)(reloadRequestTime);
  const autoFetchRef = (0, _react.useRef)(autoFetch);
  const controller = (0, _react.useRef)(new AbortController());
  const fetchWithAbort = (0, _react.useCallback)(async () => {
    controller.current.abort();
    controller.current = new AbortController();
    const signal = controller.current.signal;
    const promise = fn(createAutoAbortedClient(signal, http));
    // if `fn` doesn't return a promise it is a signal that data fetching was not initiated.
    // This can happen if the data fetching is conditional (based on certain inputs).
    // In these cases it is not desirable to invoke the global loading spinner, or change the status to success
    if (!promise) {
      return;
    }
    setResult(prevResult => ({
      data: preservePreviousData ? prevResult.data : undefined,
      // preserve data from previous state while loading next state
      status: FETCH_STATUS.LOADING,
      error: undefined
    }));
    try {
      const data = await promise;
      // when http fetches are aborted, the promise will be rejected
      // and this code is never reached. For async operations that are
      // not cancellable, we need to check whether the signal was
      // aborted before updating the result.
      if (!signal.aborted) {
        setResult({
          data,
          status: FETCH_STATUS.SUCCESS,
          error: undefined
        });
      }
      return data;
    } catch (e) {
      const err = e;
      if (!signal.aborted) {
        var _err$body$message, _err$body;
        const errorDetails = err.response ? getDetailsFromErrorResponse(err) : (_err$body$message = (_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.message) !== null && _err$body$message !== void 0 ? _err$body$message : err.message;
        if (showToastOnError) {
          notifications.toasts.addDanger({
            toastLifeTimeMs: 3000,
            title: _i18n.i18n.translate('xpack.infra.useHTTPRequest.error.title', {
              defaultMessage: `Error while fetching resource`
            }),
            text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("div", {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 173,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement("h5", {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 174,
                columnNumber: 17
              }
            }, _i18n.i18n.translate('xpack.infra.fetcher.error.status', {
              defaultMessage: `Error`
            })), errorDetails), rendering)
          });
        }
        setResult({
          data: undefined,
          status: FETCH_STATUS.FAILURE,
          error: e
        });
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, fnDeps);
  const triggerFetch = (0, _react.useCallback)(() => {
    if (requestObservable$) {
      requestObservable$.next(fetchWithAbort);
    } else {
      fetchWithAbort();
    }
  }, [requestObservable$, fetchWithAbort]);
  (0, _react.useEffect)(() => {
    // Allows the caller of useFetcher to control when the fetch can be triggered
    if (autoFetch && reloadRequestTimeUpdateEnabled) {
      setCachedReloadRequestTime(reloadRequestTime);
    }
    autoFetchRef.current = autoFetch;
  }, [autoFetch, reloadRequestTime, reloadRequestTimeUpdateEnabled]);
  (0, _react.useEffect)(() => {
    return () => {
      controller.current.abort();
    };
  }, []);
  (0, _react.useEffect)(() => {
    if (autoFetchRef.current) {
      triggerFetch();
    }
  }, [autoFetchRef, fetchWithAbort, cachedReloadRequestTime, triggerFetch]);
  return (0, _react.useMemo)(() => ({
    ...result,
    refetch: triggerFetch
  }), [result, triggerFetch]);
}