"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDocumentTitle = void 0;
var _react = require("react");
var _translations = require("../translations");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDocumentTitle = extraTitles => {
  const {
    services: {
      chrome
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _react.useEffect)(() => {
    const docTitle = [{
      text: _translations.observabilityTitle
    }, ...extraTitles].reverse().map(breadcrumb => breadcrumb.text);
    chrome.docTitle.change(docTitle);
  }, [chrome, extraTitles]);
};
exports.useDocumentTitle = useDocumentTitle;