"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingHttpClientException = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const missingHttpMessage = _i18n.i18n.translate('xpack.infra.sourceConfiguration.missingHttp', {
  defaultMessage: 'Failed to load source: No HTTP client available.'
});

/**
 * Errors
 */
class MissingHttpClientException extends Error {
  constructor() {
    super(missingHttpMessage);
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'MissingHttpClientException';
  }
}
exports.MissingHttpClientException = MissingHttpClientException;