"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsDataViewContext = exports.useMetricsDataView = exports.MetricsDataViewProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _constants = require("../../../common/constants");
var _use_kibana = require("../../hooks/use_kibana");
var _data_view = require("../../utils/data_view");
var _source = require("./source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMetricsDataView = () => {
  const {
    services: {
      dataViews
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    source
  } = (0, _source.useSourceContext)();
  const [state, refetch] = (0, _useAsyncFn.default)(async () => {
    const indexPattern = source === null || source === void 0 ? void 0 : source.configuration.metricAlias;
    if (!indexPattern) {
      return Promise.resolve(undefined);
    }
    return (0, _data_view.resolveAdHocDataView)({
      dataViewsService: dataViews,
      dataViewId: indexPattern,
      attributes: {
        name: _constants.DEFAULT_METRICS_VIEW_ATTRIBUTES.name,
        timeFieldName: _constants.DEFAULT_METRICS_VIEW_ATTRIBUTES.timeFieldName
      }
    });
  }, [dataViews, source === null || source === void 0 ? void 0 : source.configuration.metricAlias]);
  (0, _react.useEffect)(() => {
    refetch();
  }, [refetch]);
  const {
    value: metricsView,
    error,
    loading
  } = state;
  return {
    metricsView,
    loading,
    error,
    refetch
  };
};
exports.useMetricsDataView = useMetricsDataView;
const [MetricsDataViewProvider, useMetricsDataViewContext] = (0, _constate.default)(useMetricsDataView);
exports.useMetricsDataViewContext = useMetricsDataViewContext;
exports.MetricsDataViewProvider = MetricsDataViewProvider;