"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToAlertsPage = exports.LinkToAlertsHomePage = void 0;
var _react = _interopRequireDefault(require("react"));
var _rison = require("@kbn/rison");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../../hooks/use_kibana");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/shared/alerts/links/link_to_alerts_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LinkToAlertsPage = ({
  kuery,
  dateRange,
  ['data-test-subj']: dataTestSubj
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    http
  } = services;
  const linkToAlertsPage = http.basePath.prepend(`${_constants.ALERTS_PATH}?_a=${(0, _rison.encode)({
    kuery,
    rangeFrom: dateRange.from,
    rangeTo: dateRange.to,
    status: 'all'
  })}`);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.alertsLink.ariaLabel', {
      defaultMessage: 'Show all alerts'
    }),
    "data-test-subj": dataTestSubj,
    size: "xs",
    iconSide: "right",
    iconType: "sortRight",
    flush: "both",
    href: linkToAlertsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.AlertsPageLinkLabel",
    defaultMessage: "Show all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }));
};
exports.LinkToAlertsPage = LinkToAlertsPage;
const LinkToAlertsHomePage = ({
  dataTestSubj
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    http
  } = services;
  const linkToAlertsPage = http.basePath.prepend(_constants.ALERTS_PATH);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    style: {
      display: 'inline-block'
    },
    "data-test-subj": dataTestSubj,
    href: linkToAlertsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.table.tooltip.alertsLink",
    defaultMessage: "alerts.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }));
};
exports.LinkToAlertsHomePage = LinkToAlertsHomePage;