"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailsRenderPropsProvider = exports.AssetDetailsRenderProps = void 0;
exports.useAssetDetailsRenderProps = useAssetDetailsRenderProps;
exports.useAssetDetailsRenderPropsContext = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _infra_ml_capabilities = require("../../../containers/ml/infra_ml_capabilities");
var _use_asset_details_url_state = require("./use_asset_details_url_state");
var _use_metadata_state = require("./use_metadata_state");
var _use_time_range_metadata = require("../../../hooks/use_time_range_metadata");
var _use_fetcher = require("../../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAssetDetailsRenderProps(props) {
  const [urlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    metadata
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    data: timeRangeMetadata,
    status
  } = (0, _use_time_range_metadata.useTimeRangeMetadataContext)();
  const {
    updateTopbarMenuVisibilityBySchema
  } = (0, _infra_ml_capabilities.useInfraMLCapabilitiesContext)();
  const {
    entityId,
    entityName,
    entityType,
    ...rest
  } = props;
  const schema = (0, _react.useMemo)(() => {
    if (!timeRangeMetadata) return null;
    return timeRangeMetadata.preferredSchema;
  }, [timeRangeMetadata]);
  const contextSchema = props.preferredSchema ? props.preferredSchema : urlState === null || urlState === void 0 ? void 0 : urlState.preferredSchema;
  const selectedSchema = timeRangeMetadata !== null && timeRangeMetadata !== void 0 && timeRangeMetadata.schemas && (timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.schemas.length) > 1 && contextSchema ? contextSchema : schema;
  (0, _react.useEffect)(() => {
    updateTopbarMenuVisibilityBySchema(selectedSchema);
  }, [selectedSchema, updateTopbarMenuVisibilityBySchema]);
  const isLoadingTimeRangeMetadata = (0, _use_fetcher.isPending)(status);

  // When the asset entity.name is known we can load the page faster
  // Otherwise we need to use metadata response.
  const loading = !entityName && !(urlState !== null && urlState !== void 0 && urlState.name) && !(metadata !== null && metadata !== void 0 && metadata.name) || isLoadingTimeRangeMetadata;
  return {
    ...rest,
    entity: {
      id: entityId,
      name: entityName || (urlState === null || urlState === void 0 ? void 0 : urlState.name) || (metadata === null || metadata === void 0 ? void 0 : metadata.name) || '',
      type: entityType
    },
    schema: selectedSchema,
    loading
  };
}
const AssetDetailsRenderProps = exports.AssetDetailsRenderProps = (0, _constate.default)(useAssetDetailsRenderProps);
const [AssetDetailsRenderPropsProvider, useAssetDetailsRenderPropsContext] = AssetDetailsRenderProps;
exports.useAssetDetailsRenderPropsContext = useAssetDetailsRenderPropsContext;
exports.AssetDetailsRenderPropsProvider = AssetDetailsRenderPropsProvider;