"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.METRICS_TOOLTIP = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRICS_TOOLTIP = exports.METRICS_TOOLTIP = {
  hostCount: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.hostCount', {
    defaultMessage: 'Number of hosts returned by your search criteria.'
  }),
  alertsCount: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.alertsCount', {
    defaultMessage: 'The count of the active alerts'
  }),
  cpuUsage: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.cpuUsage', {
    defaultMessage: 'Average of percentage of CPU time spent in states other than Idle and IOWait, normalised by the number of CPU cores. Includes both time spent on user space and kernel space. 100% means all CPUs of the host are busy.'
  }),
  diskUsage: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.diskSpaceUsage', {
    defaultMessage: 'Percentage of disk space used.'
  }),
  diskLatency: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.diskLatency', {
    defaultMessage: 'Time spent to service disk requests.'
  }),
  memoryFree: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.memoryFree', {
    defaultMessage: 'Total available memory including page cache.'
  }),
  memoryTotal: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.memoryTotal', {
    defaultMessage: 'Total memory capacity.'
  }),
  memoryUsage: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.memoryUsage', {
    defaultMessage: 'Percentage of main memory usage excluding page cache.'
  }),
  normalizedLoad1m: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.normalizedLoad1m', {
    defaultMessage: '1 minute load average normalized by the number of CPU cores. '
  }),
  rx: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.rx', {
    defaultMessage: 'Number of bytes which have been received per second on the public interfaces of the hosts.'
  }),
  tx: _i18n.i18n.translate('xpack.infra.hostsViewPage.metrics.tooltip.tx', {
    defaultMessage: 'Number of bytes which have been sent per second on the public interfaces of the hosts.'
  })
};