"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByExpression = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _selector = require("./selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/common/group_by_expression/group_by_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_GROUP_BY_LABEL = _i18n.i18n.translate('xpack.infra.alerting.alertFlyout.groupByLabel', {
  defaultMessage: 'Group By'
});
const EVERYTHING_PLACEHOLDER = _i18n.i18n.translate('xpack.infra.alerting.alertFlyout.groupBy.placeholder', {
  defaultMessage: 'Nothing (ungrouped)'
});
const GroupByExpression = ({
  selectedGroups = [],
  fields,
  label,
  onChange
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const expressionValue = (0, _react.useMemo)(() => {
    return selectedGroups.length > 0 ? selectedGroups.join(', ') : EVERYTHING_PLACEHOLDER;
  }, [selectedGroups]);
  const labelProp = label !== null && label !== void 0 ? label : DEFAULT_GROUP_BY_LABEL;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "groupByExpression",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: labelProp,
      uppercase: true,
      value: expressionValue,
      isActive: isPopoverOpen,
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    ownFocus: true,
    panelPaddingSize: "s",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      zIndex: 11000
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, labelProp), /*#__PURE__*/_react.default.createElement(_selector.GroupBySelector, {
    selectedGroups: selectedGroups,
    onChange: onChange,
    fields: fields,
    label: labelProp,
    placeholder: EVERYTHING_PLACEHOLDER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })))));
};
exports.GroupByExpression = GroupByExpression;