"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compareTimeKeys = compareTimeKeys;
exports.timeKeyRT = exports.timeKeyIsBetween = exports.pickTimeKey = exports.minimalTimeKeyRT = exports.isTimeKey = exports.isSameTimeKey = exports.getPreviousTimeKey = exports.getNextTimeKey = exports.compareToTimeKey = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _d3Array = require("d3-array");
var rt = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const minimalTimeKeyRT = exports.minimalTimeKeyRT = rt.type({
  time: _ioTsUtils.DateFromStringOrNumber,
  tiebreaker: rt.number
});
const timeKeyRT = exports.timeKeyRT = rt.intersection([minimalTimeKeyRT, rt.partial({
  gid: rt.string,
  fromAutoReload: rt.boolean
})]);
const isTimeKey = value => value && typeof value === 'object' && typeof value.time === 'number' && typeof value.tiebreaker === 'number';
exports.isTimeKey = isTimeKey;
const pickTimeKey = value => (0, _lodash.pick)(value, ['time', 'tiebreaker']);
exports.pickTimeKey = pickTimeKey;
function compareTimeKeys(firstKey, secondKey, compareValues = _d3Array.ascending) {
  const timeComparison = compareValues(firstKey.time, secondKey.time);
  if (timeComparison === 0) {
    const tiebreakerComparison = compareValues(firstKey.tiebreaker, secondKey.tiebreaker);
    if (tiebreakerComparison === 0 && typeof firstKey.gid !== 'undefined' && typeof secondKey.gid !== 'undefined') {
      return compareValues(firstKey.gid, secondKey.gid);
    }
    return tiebreakerComparison;
  }
  return timeComparison;
}
const compareToTimeKey = (keyAccessor, compareValues) => (value, key) => compareTimeKeys(keyAccessor(value), key, compareValues);
exports.compareToTimeKey = compareToTimeKey;
const timeKeyIsBetween = (min, max, operand) => compareTimeKeys(min, operand) <= 0 && compareTimeKeys(max, operand) >= 0;
exports.timeKeyIsBetween = timeKeyIsBetween;
const getPreviousTimeKey = timeKey => ({
  ...timeKey,
  time: timeKey.time,
  tiebreaker: timeKey.tiebreaker - 1
});
exports.getPreviousTimeKey = getPreviousTimeKey;
const getNextTimeKey = timeKey => ({
  ...timeKey,
  time: timeKey.time,
  tiebreaker: timeKey.tiebreaker + 1
});
exports.getNextTimeKey = getNextTimeKey;
const isSameTimeKey = (firstKey, secondKey) => firstKey === secondKey || firstKey != null && secondKey != null && compareTimeKeys(firstKey, secondKey) === 0;
exports.isSameTimeKey = isSameTimeKey;