"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogEntryExamplesSuccessResponsePayloadRT = exports.getLogEntryExamplesResponsePayloadRT = exports.getLogEntryExamplesRequestPayloadRT = exports.LOG_ANALYSIS_GET_LOG_ENTRY_RATE_EXAMPLES_PATH = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/logs-shared-plugin/common");
var _id_formats = require("../../id_formats/v1/id_formats");
var _log_analysis = require("../../../../log_analysis");
var _shared = require("../../../shared");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_ANALYSIS_GET_LOG_ENTRY_RATE_EXAMPLES_PATH = exports.LOG_ANALYSIS_GET_LOG_ENTRY_RATE_EXAMPLES_PATH = '/api/infra/log_analysis/results/log_entry_examples';

/**
 * request
 */

const getLogEntryExamplesRequestPayloadRT = exports.getLogEntryExamplesRequestPayloadRT = rt.type({
  data: rt.intersection([rt.type({
    // the dataset to fetch the log rate examples from
    dataset: rt.string,
    // the number of examples to fetch
    exampleCount: rt.number,
    // logView
    logView: _common.persistedLogViewReferenceRT,
    idFormat: _id_formats.idFormatRT,
    // the time range to fetch the log rate examples from
    timeRange: _shared.timeRangeRT
  }), rt.partial({
    categoryId: rt.string
  })])
});
/**
 * response
 */

const getLogEntryExamplesSuccessResponsePayloadRT = exports.getLogEntryExamplesSuccessResponsePayloadRT = rt.intersection([rt.type({
  data: rt.type({
    examples: rt.array(_log_analysis.logEntryExampleRT)
  })
}), rt.partial({
  timing: _shared.routeTimingMetadataRT
})]);
const getLogEntryExamplesResponsePayloadRT = exports.getLogEntryExamplesResponsePayloadRT = rt.union([getLogEntryExamplesSuccessResponsePayloadRT, _shared.badRequestErrorRT, _shared.forbiddenErrorRT]);