"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runAndValidateEsqlQuery = runAndValidateEsqlQuery;
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _fieldTypes = require("@kbn/field-types");
var _api = require("@opentelemetry/api");
var _esqlAst = require("@kbn/esql-ast");
var _format_query_with_errors = require("./format_query_with_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function runAndValidateEsqlQuery({
  query,
  client
}) {
  // Format the query for readability before validation and execution
  let formattedQuery;
  try {
    const parser = _esqlAst.Parser.create(query);
    formattedQuery = _esqlAst.BasicPrettyPrinter.print(parser.parse().root, {
      multiline: true
    });
  } catch (e) {
    // Fallback to original query if parsing fails
    formattedQuery = query;
  }
  const {
    errors
  } = await (0, _esqlValidationAutocomplete.validateQuery)(formattedQuery, {
    // setting this to true, we don't want to validate the index / fields existence
    ignoreOnMissingCallbacks: true
  });
  const errorMessages = (0, _format_query_with_errors.formatQueryWithErrors)(formattedQuery, errors);
  return client.transport.request({
    method: 'POST',
    path: '_query',
    body: {
      query: formattedQuery
    }
  }).then(res => {
    var _esqlResponse$columns, _esqlResponse$columns2;
    const esqlResponse = res;
    const columns = (_esqlResponse$columns = (_esqlResponse$columns2 = esqlResponse.columns) === null || _esqlResponse$columns2 === void 0 ? void 0 : _esqlResponse$columns2.map(({
      name,
      type
    }) => ({
      id: name,
      name,
      meta: {
        type: (0, _fieldTypes.esFieldTypeToKibanaFieldType)(type)
      }
    }))) !== null && _esqlResponse$columns !== void 0 ? _esqlResponse$columns : [];
    return {
      columns,
      rows: esqlResponse.values
    };
  }).catch(error => {
    var _trace$getActiveSpan;
    (_trace$getActiveSpan = _api.trace.getActiveSpan()) === null || _trace$getActiveSpan === void 0 ? void 0 : _trace$getActiveSpan.recordException(error);
    return {
      error,
      ...(errorMessages.length ? {
        errorMessages
      } : {})
    };
  });
}