"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadData = void 0;
var _path = _interopRequireDefault(require("path"));
var _lodash = require("lodash");
var _pLimit = _interopRequireDefault(require("p-limit"));
var _promises = require("fs/promises");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadData = async () => {
  const [prompts, docs] = await Promise.all([loadPrompts(), loadEsqlDocs()]);
  return {
    prompts,
    docs
  };
};
exports.loadData = loadData;
const loadPrompt = async fileName => {
  return (await (0, _promises.readFile)(_path.default.join(__dirname, `../prompts/${fileName}`))).toString('utf-8');
};
const loadPrompts = async () => {
  return Promise.all([loadPrompt('examples.txt'), loadPrompt('instructions.txt'), loadPrompt('syntax.txt')]).then(([examples, instructions, syntax]) => {
    return {
      examples,
      instructions,
      syntax
    };
  });
};
const loadEsqlDocs = async () => {
  const dir = _path.default.join(__dirname, '../esql_docs');
  const files = (await (0, _promises.readdir)(dir)).filter(file => _path.default.extname(file) === '.txt');
  const limiter = (0, _pLimit.default)(10);
  return (0, _lodash.keyBy)(await Promise.all(files.map(file => limiter(async () => {
    const data = (await (0, _promises.readFile)(_path.default.join(dir, file))).toString('utf-8');
    const filename = _path.default.basename(file, '.txt');
    const keyword = filename.replace('esql-', '').replaceAll('-', '_').toUpperCase();
    return {
      keyword,
      data
    };
  }))), 'keyword');
};