"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.correctQueryWithAst = void 0;
var _esqlAst = require("@kbn/esql-ast");
var _corrections = require("./corrections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const correctQueryWithAst = query => {
  const {
    root,
    errors
  } = (0, _esqlAst.parse)(query);
  // don't try modifying anything if the query is not syntactically correct
  if (errors) {
    return {
      output: query,
      corrections: []
    };
  }
  const corrections = (0, _corrections.correctAll)(root);
  const multiline = /\r?\n/.test(query);
  const formattedQuery = _esqlAst.BasicPrettyPrinter.print(root, {
    multiline,
    pipeTab: ''
  });
  return {
    output: formattedQuery,
    corrections
  };
};
exports.correctQueryWithAst = correctQueryWithAst;