"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimespanString = isTimespanString;
exports.stringToTimespanLiteral = stringToTimespanLiteral;
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timespanStringRegexp = new RegExp(`^["']?([0-9]+)?\\s*?(${_esqlAst.TIME_SPAN_UNITS.join('|')})["']?$`, 'i');
function isTimespanString(str) {
  return Boolean(str.match(timespanStringRegexp));
}
function stringToTimespanLiteral(str) {
  const match = timespanStringRegexp.exec(str);
  if (!match) {
    throw new Error(`String "${str}" cannot be converted to timespan literal`);
  }
  const [_, quantity, unit] = match;
  return _esqlAst.Builder.expression.literal.timespan(quantity ? parseInt(quantity, 10) : 1, unit.toLowerCase());
}