"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolDefinitionToInference = exports.toolChoiceToInference = void 0;
var _lodash = require("lodash");
var _zodToJsonSchema = require("zod-to-json-schema");
var _function_calling = require("@langchain/core/utils/function_calling");
var _types = require("@langchain/core/utils/types");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toolDefinitionToInference = tools => {
  const definitions = {};
  tools.forEach(tool => {
    if ((0, _function_calling.isLangChainTool)(tool)) {
      var _tool$description;
      definitions[tool.name] = {
        description: (_tool$description = tool.description) !== null && _tool$description !== void 0 ? _tool$description : tool.name,
        schema: tool.schema ? (0, _types.isZodSchema)(tool.schema) ? zodSchemaToInference(tool.schema) : jsonSchemaToInference(tool.schema) : undefined
      };
    } else if (isToolDefinition(tool)) {
      var _tool$function$descri;
      definitions[tool.function.name] = {
        description: (_tool$function$descri = tool.function.description) !== null && _tool$function$descri !== void 0 ? _tool$function$descri : tool.function.name,
        schema: (0, _types.isZodSchema)(tool.function.parameters) ? zodSchemaToInference(tool.function.parameters) : (0, _lodash.pick)(tool.function.parameters, ['type', 'properties', 'required'])
      };
    }
  });
  return definitions;
};
exports.toolDefinitionToInference = toolDefinitionToInference;
const toolChoiceToInference = toolChoice => {
  if (toolChoice === 'any') {
    return _inferenceCommon.ToolChoiceType.required;
  }
  if (toolChoice === 'auto') {
    return _inferenceCommon.ToolChoiceType.auto;
  }
  if (toolChoice === 'none') {
    return _inferenceCommon.ToolChoiceType.none;
  }
  return {
    function: toolChoice
  };
};
exports.toolChoiceToInference = toolChoiceToInference;
function isToolDefinition(def) {
  return 'type' in def && def.type === 'function' && 'function' in def && typeof def === 'object';
}
function zodSchemaToInference(schema) {
  return (0, _lodash.pick)((0, _zodToJsonSchema.zodToJsonSchema)(schema), ['type', 'properties', 'required']);
}
function jsonSchemaToInference(schema) {
  return (0, _lodash.pick)(schema, ['type', 'properties', 'required']);
}