"use strict";

var _tsd = require("tsd");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Define a couple of concrete tool definitions used across tests
const getWeatherToolDefinition = {
  schema: {
    type: 'object',
    properties: {
      location: {
        type: 'string'
      }
    },
    required: ['location']
  },
  description: 'Get weather'
};
const getStockPriceToolDefinition = {
  schema: {
    type: 'object',
    properties: {
      symbol: {
        type: 'string'
      }
    },
    required: ['symbol']
  },
  description: 'Get stock price'
};
const noArgsToolDefinition = {
  description: 'No-args tool'
};
const myTools = {
  get_weather: getWeatherToolDefinition,
  get_stock_price: getStockPriceToolDefinition
};

/**
 * ToolsOfChoice
 */

(0, _tsd.expectAssignable)(toolsAuto);
(0, _tsd.expectAssignable)(toolsSpecific);

/**
 * ToolNamesOf
 */

(0, _tsd.expectAssignable)(name);

/**
 * ToolCallArgumentsOfToolDefinition
 */

(0, _tsd.expectType)(weatherArgs.location);
(0, _tsd.expectType)(stockArgs.symbol);
(0, _tsd.expectType)(noArgs);

/**
 * ToolCallOfToolDefinitions
 */

(0, _tsd.expectAssignable)(call);

/**
 * ToolCallOfToolOptions
 */

(0, _tsd.expectType)(callNone);
(0, _tsd.expectAssignable)(callAuto);
(0, _tsd.expectAssignable)(callSpecific);

/**
 * ToolCallbacksOfToolOptions
 */

// Provide a value matching the inferred callbacks type
const callbacks = {
  // get_weather callback should receive typed arguments
  async get_weather(toolCall) {
    return {
      response: {}
    };
  },
  // get_stock_price callback should receive typed arguments
  async get_stock_price(toolCall) {
    return {
      response: {}
    };
  }
};
(0, _tsd.expectAssignable)(callbacks);