"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatCompletionErrorCode = void 0;
exports.isTokenLimitReachedError = isTokenLimitReachedError;
exports.isToolNotFoundError = isToolNotFoundError;
exports.isToolValidationError = isToolValidationError;
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * List of code of error that are specific to the {@link ChatCompleteAPI}
 */
let ChatCompletionErrorCode = exports.ChatCompletionErrorCode = /*#__PURE__*/function (ChatCompletionErrorCode) {
  ChatCompletionErrorCode["TokenLimitReachedError"] = "tokenLimitReachedError";
  ChatCompletionErrorCode["ToolNotFoundError"] = "toolNotFoundError";
  ChatCompletionErrorCode["ToolValidationError"] = "toolValidationError";
  return ChatCompletionErrorCode;
}({});
/**
 * Error thrown if the completion call fails because of a token limit
 * error, e.g. when the context window is higher than the limit
 */
/**
 * Error thrown if the LLM called a tool that was not provided
 * in the list of available tools.
 */
/**
 * Error thrown when the LLM called a tool with parameters that
 * don't match the tool's schema.
 *
 * The level of details on the error vary depending on the underlying LLM.
 */
/**
 * Check if an error is a {@link ChatCompletionToolValidationError}
 */
function isToolValidationError(error) {
  return error instanceof _errors.InferenceTaskError && error.code === ChatCompletionErrorCode.ToolValidationError;
}

/**
 * Check if an error is a {@link ChatCompletionTokenLimitReachedError}
 */
function isTokenLimitReachedError(error) {
  return error instanceof _errors.InferenceTaskError && error.code === ChatCompletionErrorCode.TokenLimitReachedError;
}

/**
 * Check if an error is a {@link ChatCompletionToolNotFoundError}
 */
function isToolNotFoundError(error) {
  return error instanceof _errors.InferenceTaskError && error.code === ChatCompletionErrorCode.ToolNotFoundError;
}