"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bindApi = bindApi;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function bindApi(api, boundParams) {
  const {
    functionCalling,
    connectorId
  } = boundParams;
  return params => {
    return api({
      ...params,
      functionCalling,
      connectorId
    });
  };
}