"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUpdateRoute = registerUpdateRoute;
var _configSchema = require("@kbn/config-schema");
var _ = require("..");
var _validate_schemas = require("./validate_schemas");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bodySchema = _validate_schemas.templateSchema;
const paramsSchema = _configSchema.schema.object({
  name: _configSchema.schema.string()
});
function registerUpdateRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  router.put({
    path: (0, _.addBasePath)('/index_templates/{name}'),
    security: {
      authz: {
        enabled: false,
        reason: 'Relies on es client for authorization'
      }
    },
    validate: {
      body: bodySchema,
      params: paramsSchema
    }
  }, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    const {
      name
    } = request.params;
    const template = request.body;
    try {
      const {
        _kbnMeta: {
          isLegacy
        }
      } = template;

      // Verify the template exists (ES will throw 404 if not)
      const templateExists = await (0, _lib.doesTemplateExist)({
        name,
        client,
        isLegacy
      });
      if (!templateExists) {
        return response.notFound();
      }
      const dataStreamOptions = await (0, _lib.getTemplateDataStreamOptions)({
        name,
        client,
        isLegacy
      });

      // Next, update index template
      const responseBody = await (0, _lib.saveTemplate)({
        template,
        client,
        isLegacy,
        dataStreamOptions
      });
      return response.ok({
        body: responseBody
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}