"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexManagementLocatorDefinition = exports.INDEX_MANAGEMENT_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _routing = require("./application/services/routing");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_MANAGEMENT_LOCATOR_ID = exports.INDEX_MANAGEMENT_LOCATOR_ID = 'INDEX_MANAGEMENT_LOCATOR_ID';
class IndexManagementLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", INDEX_MANAGEMENT_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const location = await this.deps.managementAppLocator.getLocation({
        sectionId: 'data',
        appId: _constants.PLUGIN.ID
      });
      switch (params.page) {
        case 'index_list':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getIndexListUri)(params.filter, params.includeHiddenIndices)
            };
          }
        case 'data_stream_index_list':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getIndexListUri)(`data_stream="${params.dataStreamName}"`, true)
            };
          }
        case 'data_streams_details':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getDataStreamDetailsLink)(params.dataStreamName)
            };
          }
        case 'index_template':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getTemplateDetailsLink)(params.indexTemplate)
            };
          }
        case 'index_template_edit':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getTemplateEditLink)(params.indexTemplate, false)
            };
          }
        case 'index_template_clone':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getTemplateCloneLink)(params.indexTemplate)
            };
          }
        case 'component_template':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getComponentTemplateDetailLink)(params.componentTemplate)
            };
          }
        case 'component_template_list':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getComponentTemplateListLink)(params.filter)
            };
          }
        case 'edit_component_template':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getComponentTemplateEditLink)(params.componentTemplate)
            };
          }
        case 'clone_component_template':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getComponentTemplateCloneLink)(params.componentTemplate)
            };
          }
        case 'create_component_template':
          {
            return {
              ...location,
              path: location.path + (0, _routing.getComponentTemplateCreateLink)(params.componentTemplate)
            };
          }
      }
    });
    this.deps = deps;
  }
}
exports.IndexManagementLocatorDefinition = IndexManagementLocatorDefinition;