"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplatesForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _mappings_state_context = require("../../mappings_state_context");
var _templates_form_schema = require("./templates_form_schema");
var _documentation = require("../../../../services/documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/templates_form/templates_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const stringifyJson = json => Array.isArray(json) ? JSON.stringify(json, null, 2) : '[\n\n]';
const formSerializer = formData => {
  const {
    dynamicTemplates
  } = formData;
  let parsedTemplates;
  try {
    parsedTemplates = JSON.parse(dynamicTemplates);
    if (!Array.isArray(parsedTemplates)) {
      // User provided an object, but we need an array of objects
      parsedTemplates = [parsedTemplates];
    }
  } catch {
    // Silently swallow errors
  }
  return {
    dynamic_templates: Array.isArray(parsedTemplates) && parsedTemplates.length > 0 ? parsedTemplates : []
  };
};
const formDeserializer = formData => {
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const {
    dynamic_templates
  } = formData;
  return {
    dynamicTemplates: stringifyJson(dynamic_templates)
  };
};
const TemplatesForm = exports.TemplatesForm = /*#__PURE__*/_react.default.memo(({
  value
}) => {
  const isMounted = (0, _react.useRef)(false);
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _templates_form_schema.templatesFormSchema,
    serializer: formSerializer,
    deserializer: formDeserializer,
    defaultValue: value
  });
  const {
    subscribe,
    getFormData,
    submit: submitForm,
    reset
  } = form;
  const dispatch = (0, _mappings_state_context.useDispatch)();
  (0, _react.useEffect)(() => {
    const subscription = subscribe(({
      data,
      isValid,
      validate
    }) => {
      dispatch({
        type: 'templates.update',
        value: {
          data,
          isValid,
          validate,
          submitForm
        }
      });
    });
    return subscription.unsubscribe;
  }, [subscribe, dispatch, submitForm]);
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      // If the value has changed (it probably means that we have loaded a new JSON)
      // we need to reset the form to update the fields values.
      reset({
        resetValues: true,
        defaultValue: value
      });
    }
  }, [value, reset]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;

      // On unmount => save in the state a snapshot of the current form data.
      const dynamicTemplatesData = getFormData();
      dispatch({
        type: 'templates.save',
        value: dynamicTemplatesData
      });
    };
  }, [getFormData, dispatch]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "dynamicTemplates",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.dynamicTemplatesDescription",
    defaultMessage: "Use dynamic templates to define custom mappings that can be applied to dynamically added fields. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.documentationService.getDynamicTemplatesLink(),
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dynamicTemplatesDocumentationLink', {
        defaultMessage: 'Learn more.'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    isInvalid: form.isSubmitted && !form.isValid && !form.isSubmitting,
    error: form.getErrors(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "dynamicTemplates",
    component: _shared_imports.JsonEditorField,
    componentProps: {
      codeEditorProps: {
        ['data-test-subj']: 'dynamicTemplatesEditor',
        height: '600px',
        'aria-label': _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dynamicTemplatesEditorAriaLabel', {
          defaultMessage: 'Dynamic templates editor'
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  })));
});