"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _constants = require("../../../../constants");
var _lib = require("../../../../lib");
var _utils = require("../../../../lib/utils");
var _mappings_state_context = require("../../../../mappings_state_context");
var _shared_imports = require("../../../../shared_imports");
var _field_parameters = require("../../field_parameters");
var _reference_field_selects = require("../../field_parameters/reference_field_selects");
var _select_inference_id = require("../../field_parameters/select_inference_id");
var _field_beta_badge = require("../field_beta_badge");
var _required_parameters_forms = require("./required_parameters_forms");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/create_field/create_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formWrapper = props => /*#__PURE__*/_react2.default.createElement("form", (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 37
  }
}));
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    createFieldRequiredProps: (0, _react.css)`
      margin-top: ${euiTheme.size.l};
      padding-top: ${euiTheme.size.base};
      border-top: 1px solid ${euiTheme.colors.lightShade};
    `,
    createFieldContent: (0, _react.css)`
      position: relative;
    `
  };
};
const CreateField = exports.CreateField = /*#__PURE__*/_react2.default.memo(function CreateFieldComponent({
  allFields,
  isRootLevelField,
  isMultiField,
  isCancelable,
  onCancelAddingNewFields,
  isAddingFields,
  semanticTextInfo,
  createFieldFormRef
}) {
  const {
    isSemanticTextEnabled
  } = semanticTextInfo !== null && semanticTextInfo !== void 0 ? semanticTextInfo : {};
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    fields,
    mappingViewFields
  } = (0, _mappings_state_context.useMappingsState)();
  const fieldTypeInputRef = (0, _react2.useRef)(null);
  const styles = useStyles();
  const {
    form
  } = (0, _shared_imports.useForm)({
    serializer: _lib.fieldSerializer,
    options: {
      stripEmptyFields: false
    },
    id: 'create-field'
  });
  const [{
    type,
    subType
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['type', 'subType']
  });
  const {
    subscribe
  } = form;
  (0, _react2.useEffect)(() => {
    const subscription = subscribe(updatedFieldForm => {
      dispatch({
        type: 'fieldForm.update',
        value: updatedFieldForm
      });
    });
    return subscription.unsubscribe;
  }, [dispatch, subscribe]);
  const cancel = () => {
    if (isAddingFields && onCancelAddingNewFields) {
      onCancelAddingNewFields();
    } else {
      dispatch({
        type: 'documentField.changeStatus',
        value: 'idle'
      });
    }
  };
  const isSemanticText = form.getFormData().type === 'semantic_text';
  (0, _react2.useEffect)(() => {
    if (createFieldFormRef !== null && createFieldFormRef !== void 0 && createFieldFormRef.current) createFieldFormRef === null || createFieldFormRef === void 0 ? void 0 : createFieldFormRef.current.focus();
  }, [createFieldFormRef]);
  (0, _react2.useEffect)(() => {
    if (isSemanticText) {
      const allSemanticFields = {
        byId: {
          ...fields.byId,
          ...mappingViewFields.byId
        },
        rootLevelFields: [],
        aliases: {},
        maxNestedDepth: 0
      };
      const defaultName = (0, _utils.getFieldByPathName)(allSemanticFields, 'semantic_text') ? '' : 'semantic_text';
      if (!form.getFormData().name) {
        form.setFieldValue('name', defaultName);
      }
      if (!form.getFormData().reference_field) {
        form.setFieldValue('reference_field', '');
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isSemanticText]);
  const submitForm = async (e, exitAfter = false, clickOutside = false) => {
    if (e) {
      e.preventDefault();
    }
    const {
      isValid,
      data
    } = await form.submit();
    if (isValid && !clickOutside) {
      if ((0, _utils.isSemanticTextField)(data) && !data.inference_id) {
        const {
          inference_id: inferenceId,
          ...rest
        } = data;
        dispatch({
          type: 'field.add',
          value: rest
        });
      } else {
        dispatch({
          type: 'field.add',
          value: data
        });
      }
      if (exitAfter) {
        cancel();
      }
      form.reset();
    }
    if (fieldTypeInputRef.current) {
      fieldTypeInputRef.current.focus();
    }
  };
  const onClickOutside = () => {
    const name = form.getFields().name.value;
    if (name.trim() === '') {
      if (isCancelable !== false) {
        cancel();
      }
    } else {
      submitForm(undefined, true, true);
    }
  };
  const renderFormFields = () => {
    var _type$, _type$2;
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_field_parameters.TypeParameter, {
      isRootLevelField: isRootLevelField,
      isMultiField: isMultiField,
      showDocLink: true,
      isSemanticTextEnabled: isSemanticTextEnabled,
      fieldTypeInputRef: fieldTypeInputRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 9
      }
    })), type !== undefined && /*#__PURE__*/_react2.default.createElement(_field_parameters.SubTypeParameter, {
      key: type === null || type === void 0 ? void 0 : (_type$ = type[0]) === null || _type$ === void 0 ? void 0 : _type$.value,
      type: type === null || type === void 0 ? void 0 : (_type$2 = type[0]) === null || _type$2 === void 0 ? void 0 : _type$2.value,
      isMultiField: isMultiField !== null && isMultiField !== void 0 ? isMultiField : false,
      isRootLevelField: isRootLevelField,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 9
      }
    }), isSemanticText && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_reference_field_selects.ReferenceFieldSelects, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_field_parameters.NameParameter, {
      isSemanticText: isSemanticText,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 9
      }
    })));
  };
  const renderRequiredParametersForm = () => {
    var _type$3, _subType$;
    if (!type) return null;
    const RequiredParametersForm = (0, _required_parameters_forms.getRequiredParametersFormForType)(type === null || type === void 0 ? void 0 : (_type$3 = type[0]) === null || _type$3 === void 0 ? void 0 : _type$3.value, subType === null || subType === void 0 ? void 0 : (_subType$ = subType[0]) === null || _subType$ === void 0 ? void 0 : _subType$.value);
    if (!RequiredParametersForm) {
      return null;
    }
    const typeDefinition = _constants.TYPE_DEFINITION[type === null || type === void 0 ? void 0 : type[0].value];
    return /*#__PURE__*/_react2.default.createElement("div", {
      css: styles.createFieldRequiredProps,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 7
      }
    }, typeDefinition !== null && typeDefinition !== void 0 && typeDefinition.isBeta ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_field_beta_badge.FieldBetaBadge, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 13
      }
    })) : null, /*#__PURE__*/_react2.default.createElement(RequiredParametersForm, {
      key: subType !== null && subType !== void 0 ? subType : type,
      allFields: allFields,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 9
      }
    }));
  };
  const renderFormActions = () => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 5
    }
  }, (isCancelable !== false || isAddingFields) && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: cancel,
    "data-test-subj": "cancelButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: submitForm,
    type: "submit",
    "data-test-subj": "addButton",
    isDisabled: form.getErrors().length > 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 9
    }
  }, isMultiField ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.addMultiFieldButtonLabel', {
    defaultMessage: 'Add multi-field'
  }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.addFieldButtonLabel', {
    defaultMessage: 'Add field'
  }))));
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: onClickOutside,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_shared_imports.Form, {
    form: form,
    FormWrapper: formWrapper,
    onSubmit: submitForm,
    "data-test-subj": "createFieldForm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "m",
    panelRef: createFieldFormRef,
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: styles.createFieldContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 13
    }
  }, renderFormFields(), renderRequiredParametersForm(), isSemanticText && /*#__PURE__*/_react2.default.createElement(_select_inference_id.SelectInferenceId, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 34
    }
  }), renderFormActions())))));
});