"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.splitSizeAndUnits = exports.serializeAsESLifecycle = exports.deserializeESLifecycle = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const splitSizeAndUnits = field => {
  let size = '';
  let unit = '';
  const result = /(\d+)(\w+)/.exec(field);
  if (result) {
    size = result[1];
    unit = result[2];
  }
  return {
    size,
    unit
  };
};
exports.splitSizeAndUnits = splitSizeAndUnits;
const serializeAsESLifecycle = lifecycle => {
  if (!lifecycle || !(lifecycle !== null && lifecycle !== void 0 && lifecycle.enabled)) {
    return undefined;
  }
  const {
    infiniteDataRetention,
    value,
    unit
  } = lifecycle;
  if (infiniteDataRetention) {
    return {
      enabled: true
    };
  }
  return {
    enabled: true,
    data_retention: `${value}${unit}`
  };
};
exports.serializeAsESLifecycle = serializeAsESLifecycle;
const deserializeESLifecycle = lifecycle => {
  if (!lifecycle || !(lifecycle !== null && lifecycle !== void 0 && lifecycle.enabled)) {
    return {
      enabled: false
    };
  }
  if (!lifecycle.data_retention) {
    return {
      enabled: true,
      infiniteDataRetention: true
    };
  }
  const {
    size,
    unit
  } = splitSizeAndUnits(lifecycle.data_retention);
  return {
    enabled: true,
    value: Number(size),
    unit
  };
};
exports.deserializeESLifecycle = deserializeESLifecycle;