"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.init = init;
exports.sendDelete = sendDelete;
exports.sendGet = sendGet;
exports.sendPost = sendPost;
exports.useRequest = void 0;
var _public = require("@kbn/es-ui-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * TODO:
 * IMPORTANT: Please see how {@link BreadcrumbService} is set up for an example of how these services should be set up
 * in future. The pattern in this file is legacy and should be updated to conform to the plugin lifecycle.
 */

let _httpClient;
function init(httpClient) {
  _httpClient = httpClient;
}
function getFullPath(path) {
  const apiPrefix = '/api/index_lifecycle_management';
  if (path) {
    return `${apiPrefix}/${path}`;
  }
  return apiPrefix;
}
function sendPost(path, payload, query) {
  return _httpClient.post(getFullPath(path), {
    body: JSON.stringify(payload),
    query
  });
}
function sendGet(path, query) {
  return _httpClient.get(getFullPath(path), {
    query
  });
}
function sendDelete(path) {
  return _httpClient.delete(getFullPath(path));
}
const useRequest = config => {
  return (0, _public.useRequest)(_httpClient, {
    ...config,
    path: getFullPath(config.path)
  });
};
exports.useRequest = useRequest;