"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const ilmTimelineBarHeight = euiTheme.size.s;
  const isBorealis = euiTheme.themeName === 'EUI_THEME_BOREALIS';
  const timelineIconColors = {
    hot: isBorealis ? euiTheme.colors.vis.euiColorVis6 : euiTheme.colors.vis.euiColorVis9,
    warm: isBorealis ? euiTheme.colors.vis.euiColorVis9 : euiTheme.colors.vis.euiColorVis5,
    cold: isBorealis ? euiTheme.colors.vis.euiColorVis2 : euiTheme.colors.vis.euiColorVis1,
    frozen: euiTheme.colors.vis.euiColorVis4
  };
  return {
    container: (0, _react.css)`
      overflow: hidden;
      width: 100%;
    `,
    /*
     * Let the delete icon sit on the same line as the phase color bars
     */
    phasesContainer: (0, _react.css)`
      display: inline-block;
      width: 100%;
      margin-top: ${euiTheme.size.s};
    `,
    /*
     * Let the phase color bars sit horizontally
     */
    phase: (0, _react.css)`
      display: inline-block;
      padding-left: ${euiTheme.size.s};
      padding-right: ${euiTheme.size.s};

      &:first-child {
        padding-left: 0;
        padding-right: ${euiTheme.size.s};
      }

      &:last-child {
        padding-left: ${euiTheme.size.s};
        padding-right: 0;
      }

      &:only-child {
        padding-left: 0;
        padding-right: 0;
      }
    `,
    /*
     * Create a bit of space between the timeline and the delete icon
     */
    deleteIconContainer: (0, _react.css)`
      padding: ${euiTheme.size.m};
      margin-left: ${euiTheme.size.m};
      background-color: ${euiTheme.colors.lightestShade};
      color: ${euiTheme.colors.darkShade};
      border-radius: 50%;
    `,
    colorBar: (0, _react.css)`
      display: inline-block;
      height: ${ilmTimelineBarHeight};
      margin-top: ${euiTheme.size.s};
      margin-bottom: ${euiTheme.size.xs};
      border-radius: calc(${ilmTimelineBarHeight} / 2);
      width: 100%;
    `,
    hotColorBar: (0, _react.css)`
      display: inline-block;
      height: ${ilmTimelineBarHeight};
      margin-top: ${euiTheme.size.s};
      margin-bottom: ${euiTheme.size.xs};
      border-radius: calc(${ilmTimelineBarHeight} / 2);
      width: 100%;
      background-color: ${timelineIconColors.hot};
    `,
    warmColorBar: (0, _react.css)`
      display: inline-block;
      height: ${ilmTimelineBarHeight};
      margin-top: ${euiTheme.size.s};
      margin-bottom: ${euiTheme.size.xs};
      border-radius: calc(${ilmTimelineBarHeight} / 2);
      width: 100%;
      background-color: ${timelineIconColors.warm};
    `,
    coldColorBar: (0, _react.css)`
      display: inline-block;
      height: ${ilmTimelineBarHeight};
      margin-top: ${euiTheme.size.s};
      margin-bottom: ${euiTheme.size.xs};
      border-radius: calc(${ilmTimelineBarHeight} / 2);
      width: 100%;
      background-color: ${timelineIconColors.cold};
    `,
    frozenColorBar: (0, _react.css)`
      display: inline-block;
      height: ${ilmTimelineBarHeight};
      margin-top: ${euiTheme.size.s};
      margin-bottom: ${euiTheme.size.xs};
      border-radius: calc(${ilmTimelineBarHeight} / 2);
      width: 100%;
      background-color: ${timelineIconColors.frozen};
    `,
    hotPhase: (0, _react.css)`
      width: var(--ilm-timeline-hot-phase-width);
    `,
    warmPhase: (0, _react.css)`
      width: var(--ilm-timeline-warm-phase-width);
    `,
    coldPhase: (0, _react.css)`
      width: var(--ilm-timeline-cold-phase-width);
    `,
    frozenPhase: (0, _react.css)`
      width: var(--ilm-timeline-frozen-phase-width);
    `
  };
};
exports.useStyles = useStyles;