"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFeature = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerFeature = homePlugin => {
  homePlugin.featureCatalogue.register({
    id: 'grokdebugger',
    title: _i18n.i18n.translate('xpack.grokDebugger.registryProviderTitle', {
      defaultMessage: 'Grok Debugger'
    }),
    description: _i18n.i18n.translate('xpack.grokDebugger.registryProviderDescription', {
      defaultMessage: 'Simulate and debug grok patterns for data transformation on ingestion.'
    }),
    icon: 'grokApp',
    path: '/app/dev_tools#/grokdebugger',
    showOnHomePage: false,
    category: 'admin'
  });
};
exports.registerFeature = registerFeature;