"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setDatasource = exports.requestDatasource = exports.hasDatasourceSelector = exports.datasourceSelector = exports.datasourceReducer = exports.datasourceLoaded = void 0;
var _typescriptFsa = _interopRequireDefault(require("typescript-fsa"));
var _dist = require("typescript-fsa-reducers/dist");
var _reselect = require("reselect");
var _global = require("./global");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionCreator = (0, _typescriptFsa.default)('x-pack/graph/datasource');
/**
 * Sets the current datasource. This will not trigger a load of fields
 */
const setDatasource = exports.setDatasource = actionCreator('SET_DATASOURCE');

/**
 * Sets the current datasource. This will trigger a load of fields and overwrite the current
 * fields configuration
 */
const requestDatasource = exports.requestDatasource = actionCreator('SET_DATASOURCE_REQUEST');

/**
 * Datasource loading finished successfully.
 */
const datasourceLoaded = exports.datasourceLoaded = actionCreator('SET_DATASOURCE_SUCCESS');
const initialDatasource = {
  current: {
    type: 'none'
  },
  loading: false
};
const datasourceReducer = exports.datasourceReducer = (0, _dist.reducerWithInitialState)(initialDatasource).case(_global.reset, () => initialDatasource).case(setDatasource, (_oldDatasource, newDatasource) => ({
  current: newDatasource,
  loading: false
})).case(requestDatasource, (_oldDatasource, newDatasource) => ({
  current: newDatasource,
  loading: true
})).case(datasourceLoaded, datasource => ({
  ...datasource,
  loading: false
})).build();
const datasourceSelector = state => state.datasource;
exports.datasourceSelector = datasourceSelector;
const hasDatasourceSelector = exports.hasDatasourceSelector = (0, _reselect.createSelector)(datasourceSelector, datasource => datasource.current.type !== 'none');