"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInspector = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInspector = ({
  inspect,
  requestAdapter
}) => {
  const [inspectorSession, setInspectorSession] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    return () => {
      if (inspectorSession) {
        inspectorSession.close();
      }
    };
  }, [inspectorSession]);
  const onOpenInspector = (0, _react.useCallback)(() => {
    const session = inspect.open({
      requests: requestAdapter
    }, {});
    setInspectorSession(session);
  }, [inspect, requestAdapter]);
  return {
    onOpenInspector
  };
};
exports.useInspector = useInspector;