"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGenAiConnectors = useGenAiConnectors;
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGenAiConnectors() {
  const {
    services: {
      genAiSettingsApi
    }
  } = (0, _use_kibana.useKibana)();
  const [connectors, setConnectors] = (0, _react.useState)(undefined);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(undefined);
  const fetchConnectors = (0, _react.useCallback)(async signal => {
    setLoading(true);
    setError(undefined);
    try {
      const res = await genAiSettingsApi('GET /internal/gen_ai_settings/connectors', {
        signal: signal !== null && signal !== void 0 ? signal : null
      });
      setConnectors(res);
    } catch (e) {
      // Ignore aborts
      if ((e === null || e === void 0 ? void 0 : e.name) !== 'AbortError') {
        setError(e);
        setConnectors(undefined);
      }
    } finally {
      setLoading(false);
    }
  }, [genAiSettingsApi]);
  (0, _react.useEffect)(function fetchGenAiConnectors() {
    const controller = new AbortController();
    fetchConnectors(controller.signal);
    return () => controller.abort();
  }, [fetchConnectors]);
  return {
    connectors,
    loading,
    error,
    reload: () => {
      fetchConnectors();
    }
  };
}