"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFieldsMetadataExtractors = void 0;
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerFieldsMetadataExtractors = ({
  core,
  fieldsMetadata
}) => {
  fieldsMetadata.registerIntegrationFieldsExtractor(async ({
    integration,
    dataset
  }) => {
    try {
      const [_core, _startDeps, {
        packageService
      }] = await core.getStartServices();
      return packageService.asInternalUser.getPackageFieldsMetadata({
        packageName: integration,
        datasetName: dataset
      });
    } catch (error) {
      _.appContextService.getLogger().warn(`registerIntegrationFieldsExtractor error: ${error}`);
      throw error;
    }
  });
  fieldsMetadata.registerIntegrationListExtractor(async () => {
    const [_core, _startDeps, {
      packageService
    }] = await core.getStartServices();
    try {
      const packages = await packageService.asInternalUser.getPackages();
      return packages.map(({
        id,
        name,
        version
      }) => ({
        id,
        name,
        version
      }));
    } catch (error) {
      return [];
    }
  });
};
exports.registerFieldsMetadataExtractors = registerFieldsMetadataExtractors;