"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.packagePolicyHasFrozenVariablesUpdate = packagePolicyHasFrozenVariablesUpdate;
exports.updateFrozenInputs = updateFrozenInputs;
var _package_policy = require("../package_policy");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isFrozenAndDifferent(preconfiguredVar, existingVar) {
  var _preconfiguredVar$fro;
  return ((_preconfiguredVar$fro = preconfiguredVar === null || preconfiguredVar === void 0 ? void 0 : preconfiguredVar.frozen) !== null && _preconfiguredVar$fro !== void 0 ? _preconfiguredVar$fro : false) && existingVar !== undefined && ((0, _utils.isDifferent)(existingVar.value, preconfiguredVar.value) || (0, _utils.isDifferent)(existingVar.frozen, preconfiguredVar.frozen));
}
function updateFrozenVars(preconfiguredVars, currentVars) {
  for (const inputVar of preconfiguredVars) {
    const varToUpdate = currentVars ? currentVars[inputVar.name] : undefined;
    if (isFrozenAndDifferent(inputVar, varToUpdate)) {
      varToUpdate.value = inputVar.value;
      varToUpdate.frozen = inputVar.frozen;
    }
  }
}
function frozenVarsAreDifferent(preconfiguredVars, currentVars) {
  for (const preconfiguredInputVar of preconfiguredVars) {
    const currentVar = currentVars ? currentVars[preconfiguredInputVar.name] : undefined;
    if (isFrozenAndDifferent(preconfiguredInputVar, currentVar)) {
      return true;
    }
  }
}
function packagePolicyHasFrozenVariablesUpdate(existingPackagePolicy, preconfiguredInputs) {
  for (const preconfiguredInput of preconfiguredInputs) {
    var _preconfiguredInput$v;
    const currentInput = existingPackagePolicy.inputs.find(existingInput => existingInput.type === preconfiguredInput.type);
    if (!currentInput) {
      continue;
    }
    if (frozenVarsAreDifferent((_preconfiguredInput$v = preconfiguredInput.vars) !== null && _preconfiguredInput$v !== void 0 ? _preconfiguredInput$v : [], currentInput.vars)) {
      return true;
    }
    for (const preconfiguredStream of (_preconfiguredInput$s = preconfiguredInput.streams) !== null && _preconfiguredInput$s !== void 0 ? _preconfiguredInput$s : []) {
      var _preconfiguredInput$s, _currentInput$streams, _preconfiguredStream$;
      const currentStream = currentInput === null || currentInput === void 0 ? void 0 : (_currentInput$streams = currentInput.streams) === null || _currentInput$streams === void 0 ? void 0 : _currentInput$streams.find(s => s.data_stream.dataset === preconfiguredStream.data_stream.dataset && s.data_stream.type === preconfiguredStream.data_stream.type);
      if (!currentStream) {
        continue;
      }
      if (frozenVarsAreDifferent((_preconfiguredStream$ = preconfiguredStream.vars) !== null && _preconfiguredStream$ !== void 0 ? _preconfiguredStream$ : [], currentStream.vars)) {
        return true;
      }
    }
  }
  return false;
}
async function updateFrozenInputs(esClient, soClient, packagePolicy, inputs) {
  if (!packagePolicy.package) {
    //  We do not support package policies without package
    return;
  }
  const updatePackagePolicy = {
    ...packagePolicy
  };
  for (const input of inputs) {
    var _input$vars;
    const inputToUpdate = updatePackagePolicy.inputs.find(i => i.type === input.type);
    if (!inputToUpdate) {
      continue;
    }
    updateFrozenVars((_input$vars = input.vars) !== null && _input$vars !== void 0 ? _input$vars : [], inputToUpdate.vars);
    for (const stream of (_input$streams = input.streams) !== null && _input$streams !== void 0 ? _input$streams : []) {
      var _input$streams, _inputToUpdate$stream, _stream$vars;
      const streamToUpdate = (_inputToUpdate$stream = inputToUpdate.streams) === null || _inputToUpdate$stream === void 0 ? void 0 : _inputToUpdate$stream.find(s => s.data_stream.dataset === stream.data_stream.dataset && s.data_stream.type === stream.data_stream.type);
      if (!streamToUpdate) {
        continue;
      }
      updateFrozenVars((_stream$vars = stream.vars) !== null && _stream$vars !== void 0 ? _stream$vars : [], streamToUpdate.vars);
    }
  }
  await _package_policy.packagePolicyService.update(soClient, esClient, packagePolicy.id, updatePackagePolicy, {
    force: true,
    bumpRevision: false
  });
}