"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetToHostFilesClient = void 0;
var _assert = _interopRequireDefault(require("assert"));
var _server = require("@kbn/files-plugin/server");
var _uuid = require("uuid");
var _errors = require("../../errors");
var _client_from_host = require("./client_from_host");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FleetToHostFilesClient extends _client_from_host.FleetFromHostFilesClient {
  async get(fileId) {
    const esFile = await this.esFileClient.get({
      id: fileId
    });
    const file = this.mapIndexedDocToFleetFile(esFile);
    await this.adjustFileStatusIfNeeded(file);
    return file;
  }
  async create(fileStream, agentIds) {
    var _fileStream$hapi$file, _fileStream$hapi$head;
    (0, _assert.default)(agentIds.length > 0, new _errors.FleetFilesClientError('Missing agentIds!'));
    const uploadedFile = await this.esFileClient.create({
      id: (0, _uuid.v4)(),
      metadata: {
        name: (_fileStream$hapi$file = fileStream.hapi.filename) !== null && _fileStream$hapi$file !== void 0 ? _fileStream$hapi$file : 'unknown_file_name',
        mime: (_fileStream$hapi$head = fileStream.hapi.headers['content-type']) !== null && _fileStream$hapi$head !== void 0 ? _fileStream$hapi$head : 'application/octet-stream',
        meta: {
          target_agents: agentIds,
          action_id: ''
        }
      }
    });
    await uploadedFile.uploadContent(fileStream, undefined, {
      transforms: [(0, _server.createFileHashTransform)()]
    });
    (0, _assert.default)(uploadedFile.data.hash && uploadedFile.data.hash.sha256, new _errors.FleetFilesClientError('File hash was not generated!'));
    return this.mapIndexedDocToFleetFile(uploadedFile);
  }
  async update(fileId, updates = {}) {
    var _ref, _file$data$meta, _ref2, _file$data$meta2;
    const file = await this.esFileClient.get({
      id: fileId
    });
    const {
      agents,
      actionId
    } = updates;
    const meta = {
      target_agents: (_ref = agents !== null && agents !== void 0 ? agents : (_file$data$meta = file.data.meta) === null || _file$data$meta === void 0 ? void 0 : _file$data$meta.target_agents) !== null && _ref !== void 0 ? _ref : [],
      action_id: (_ref2 = actionId !== null && actionId !== void 0 ? actionId : (_file$data$meta2 = file.data.meta) === null || _file$data$meta2 === void 0 ? void 0 : _file$data$meta2.action_id) !== null && _ref2 !== void 0 ? _ref2 : ''
    };
    await file.update({
      meta
    });
    return this.mapIndexedDocToFleetFile(file);
  }
  async delete(fileId) {
    await this.esFileClient.delete({
      id: fileId,
      hasContent: true
    });
  }
}
exports.FleetToHostFilesClient = FleetToHostFilesClient;