"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepSaveSystemObject = stepSaveSystemObject;
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _constants = require("../../../../../constants");
var _package_policy = require("../../../../package_policy");
var _audit_logging = require("../../../../audit_logging");
var _utils = require("../../utils");
var _install_errors_helpers = require("../../install_errors_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepSaveSystemObject(context) {
  var _updatedPackage$attri, _updatedPackage$attri2;
  const {
    packageInstallContext,
    savedObjectsClient,
    logger,
    esClient,
    installedPkg,
    packageAssetRefs
  } = context;
  const {
    packageInfo
  } = packageInstallContext;
  const {
    name: pkgName,
    version: pkgVersion
  } = packageInfo;
  _audit_logging.auditLoggingService.writeCustomSoAuditLog({
    action: 'update',
    id: pkgName,
    name: pkgName,
    savedObjectType: _constants.PACKAGES_SAVED_OBJECT_TYPE
  });
  await (0, _utils.withPackageSpan)('Update install status', () => {
    var _installedPkg$attribu;
    return savedObjectsClient.update(_constants.PACKAGES_SAVED_OBJECT_TYPE, pkgName, {
      version: pkgVersion,
      install_version: pkgVersion,
      install_status: 'installed',
      package_assets: packageAssetRefs,
      install_format_schema_version: _constants.FLEET_INSTALL_FORMAT_VERSION,
      latest_install_failed_attempts: (0, _install_errors_helpers.clearLatestFailedAttempts)(pkgVersion, (_installedPkg$attribu = installedPkg === null || installedPkg === void 0 ? void 0 : installedPkg.attributes.latest_install_failed_attempts) !== null && _installedPkg$attribu !== void 0 ? _installedPkg$attribu : []),
      rolled_back: !!(installedPkg !== null && installedPkg !== void 0 && installedPkg.attributes.version) && (0, _lt.default)(pkgVersion, installedPkg === null || installedPkg === void 0 ? void 0 : installedPkg.attributes.version)
    });
  });

  // Need to refetch the installation again to retrieve all the attributes
  const updatedPackage = await savedObjectsClient.get(_constants.PACKAGES_SAVED_OBJECT_TYPE, pkgName);
  logger.debug(`Package install - Install status ${updatedPackage === null || updatedPackage === void 0 ? void 0 : (_updatedPackage$attri = updatedPackage.attributes) === null || _updatedPackage$attri === void 0 ? void 0 : _updatedPackage$attri.install_status}`);
  // If the package is flagged with the `keep_policies_up_to_date` flag, upgrade its
  // associated package policies after installation
  if (updatedPackage.attributes.keep_policies_up_to_date) {
    await (0, _utils.withPackageSpan)('Upgrade package policies', async () => {
      const policyIdsToUpgrade = await _package_policy.packagePolicyService.listIds(savedObjectsClient, {
        page: 1,
        perPage: _constants.SO_SEARCH_LIMIT,
        kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${pkgName}`
      });
      logger.debug(`Package install - Package is flagged with keep_policies_up_to_date, upgrading its associated package policies ${policyIdsToUpgrade}`);
      await _package_policy.packagePolicyService.bulkUpgrade(savedObjectsClient, esClient, policyIdsToUpgrade.items);
    });
  }
  logger.debug(`Install status ${updatedPackage === null || updatedPackage === void 0 ? void 0 : (_updatedPackage$attri2 = updatedPackage.attributes) === null || _updatedPackage$attri2 === void 0 ? void 0 : _updatedPackage$attri2.install_status} - Installation complete!`);
}