"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupArchiveEntriesStep = cleanupArchiveEntriesStep;
exports.stepSaveArchiveEntries = stepSaveArchiveEntries;
var _constants = require("../../../../../constants");
var _storage = require("../../../archive/storage");
var _utils = require("../../utils");
var _types = require("../../../../../../common/types");
var _archive = require("../../../archive");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepSaveArchiveEntries(context) {
  const {
    packageInstallContext,
    savedObjectsClient,
    installSource,
    useStreaming
  } = context;
  const {
    packageInfo,
    archiveIterator
  } = packageInstallContext;
  let assetsToSaveMap = new Map();
  let packageAssetRefs = [];
  async function flushAssets() {
    const paths = Array.from(assetsToSaveMap.keys());
    const packageAssetResults = await (0, _utils.withPackageSpan)('Update archive entries', () => (0, _storage.saveArchiveEntriesFromAssetsMap)({
      savedObjectsClient,
      assetsMap: assetsToSaveMap,
      paths,
      packageInfo,
      installSource
    }));
    packageAssetRefs = [...packageAssetRefs, ...packageAssetResults.saved_objects.map(result => {
      var _result$attributes;
      return {
        id: result.id,
        path: (_result$attributes = result.attributes) === null || _result$attributes === void 0 ? void 0 : _result$attributes.asset_path,
        type: _constants.ASSETS_SAVED_OBJECT_TYPE
      };
    })];
    assetsToSaveMap = new Map();
  }
  await archiveIterator.traverseEntries(async entry => {
    const assetType = (0, _archive.getPathParts)(entry.path).type;
    if (assetType === 'security_rule' && useStreaming) {
      // Skip security rules to avoid storing to many things
    } else {
      assetsToSaveMap.set(entry.path, entry.buffer);
    }
    if (assetsToSaveMap.size > 100) {
      await flushAssets();
    }
  });
  await flushAssets();
  return {
    packageAssetRefs
  };
}
async function cleanupArchiveEntriesStep(context) {
  var _installedPkg$attribu;
  const {
    logger,
    savedObjectsClient,
    installedPkg,
    retryFromLastState,
    force,
    initialState
  } = context;

  // In case of retry clean up previous installed assets
  if (!force && retryFromLastState && initialState === _types.INSTALL_STATES.SAVE_ARCHIVE_ENTRIES && installedPkg !== null && installedPkg !== void 0 && (_installedPkg$attribu = installedPkg.attributes) !== null && _installedPkg$attribu !== void 0 && _installedPkg$attribu.package_assets && installedPkg.attributes.package_assets.length > 0) {
    const {
      package_assets: packageAssets
    } = installedPkg.attributes;
    logger.debug('Retry transition - clean up package archive assets');
    await (0, _utils.withPackageSpan)('Retry transition - clean up package archive assets', async () => {
      await (0, _storage.removeArchiveEntries)({
        savedObjectsClient,
        refs: packageAssets
      });
    });
  }
}