"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterOutExcludedDataStreamTypes = filterOutExcludedDataStreamTypes;
exports.shouldIncludePackageWithDatastreamTypes = shouldIncludePackageWithDatastreamTypes;
exports.shouldIncludePolicyTemplateWithDatastreamTypes = shouldIncludePolicyTemplateWithDatastreamTypes;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function shouldIncludePackageWithDatastreamTypes(pkg, excludeDataStreamTypes = []) {
  var _ref, _pkg$data_streams;
  const shouldInclude = ((_ref = pkg.data_streams || []) === null || _ref === void 0 ? void 0 : _ref.length) === 0 || ((_pkg$data_streams = pkg.data_streams) === null || _pkg$data_streams === void 0 ? void 0 : _pkg$data_streams.some(dataStream => {
    return !excludeDataStreamTypes.includes(dataStream.type);
  }));
  return shouldInclude;
}
function shouldIncludePolicyTemplateWithDatastreamTypes(pkg, policyTemplate, excludeDataStreamTypes = []) {
  var _policyTemplateIntegr;
  const policyTemplateIntegrationTemplate = policyTemplate;
  if (!policyTemplateIntegrationTemplate.data_streams || policyTemplateIntegrationTemplate.data_streams.length === 0) {
    return true;
  }
  return (_policyTemplateIntegr = policyTemplateIntegrationTemplate.data_streams) === null || _policyTemplateIntegr === void 0 ? void 0 : _policyTemplateIntegr.some(dataStream => {
    var _pkg$data_streams2;
    const pkgDataStream = (_pkg$data_streams2 = pkg.data_streams) === null || _pkg$data_streams2 === void 0 ? void 0 : _pkg$data_streams2.find(ds => ds.dataset.includes(`.${dataStream}`));
    if (!pkgDataStream) {
      return true;
    }
    return !excludeDataStreamTypes.includes(pkgDataStream.type);
  });
}

/**
 * Filter data_streams and policy templates to respect excluded DataStreamTypes
 */
function filterOutExcludedDataStreamTypes(packageList, excludeDataStreamTypes = []) {
  if (excludeDataStreamTypes.length > 0) {
    // filter out packages where all data streams have excluded types e.g. metrics
    return packageList.reduce((acc, pkg) => {
      const shouldInclude = shouldIncludePackageWithDatastreamTypes(pkg, excludeDataStreamTypes);
      if (shouldInclude) {
        var _pkg$data_streams$fil, _pkg$data_streams3, _pkg$policy_templates;
        // filter out excluded data stream types
        const filteredDataStreams = (_pkg$data_streams$fil = (_pkg$data_streams3 = pkg.data_streams) === null || _pkg$data_streams3 === void 0 ? void 0 : _pkg$data_streams3.filter(dataStream => !excludeDataStreamTypes.includes(dataStream.type))) !== null && _pkg$data_streams$fil !== void 0 ? _pkg$data_streams$fil : [];

        // filter out excluded policy templates
        const filteredPolicyTemplates = (_pkg$policy_templates = pkg.policy_templates) === null || _pkg$policy_templates === void 0 ? void 0 : _pkg$policy_templates.filter(policyTemplate => {
          return shouldIncludePolicyTemplateWithDatastreamTypes(pkg, policyTemplate, excludeDataStreamTypes);
        });
        acc.push({
          ...pkg,
          data_streams: filteredDataStreams,
          policy_templates: filteredPolicyTemplates
        });
      }
      return acc;
    }, []);
  }
  return packageList;
}