"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopTransforms = exports.deleteTransforms = exports.deleteTransformRefs = void 0;
var _pMap = _interopRequireDefault(require("p-map"));
var _types = require("../../../../types");
var _constants = require("../../../../../common/constants");
var _app_context = require("../../../app_context");
var _retry = require("../retry");
var _constants2 = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stopTransforms = async (transformIds, esClient) => {
  for (const transformId of transformIds) {
    await esClient.transform.stopTransform({
      transform_id: transformId,
      force: true
    }, {
      ignore: [404]
    });
  }
};
exports.stopTransforms = stopTransforms;
const deleteTransforms = async (esClient, transformIds, deleteDestinationIndices = false, secondaryAuth) => {
  const logger = _app_context.appContextService.getLogger();
  if (transformIds.length) {
    logger.info(`Deleting currently installed transform ids ${transformIds}`);
  }
  await (0, _pMap.default)(transformIds, async transformId => {
    await stopTransforms([transformId], esClient);
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.deleteTransform({
      force: true,
      transform_id: transformId,
      delete_dest_index: deleteDestinationIndices
    }, {
      ...(secondaryAuth ? secondaryAuth : {}),
      ignore: [404]
    }));
    logger.info(`Deleted: ${transformId}`);
  }, {
    concurrency: _constants2.MAX_CONCURRENT_TRANSFORMS_OPERATIONS
  });
};
exports.deleteTransforms = deleteTransforms;
const deleteTransformRefs = async (savedObjectsClient, installedEsAssets, pkgName, installedEsIdToRemove, currentInstalledEsTransformIds) => {
  const seen = new Set();
  const filteredAssets = installedEsAssets.filter(({
    type,
    id
  }) => {
    if (type !== _types.ElasticsearchAssetType.transform) return true;
    const add = (currentInstalledEsTransformIds.includes(id) || !installedEsIdToRemove.includes(id)) && !seen.has(id);
    seen.add(id);
    return add;
  });
  return savedObjectsClient.update(_constants.PACKAGES_SAVED_OBJECT_TYPE, pkgName, {
    installed_es: filteredAssets
  });
};
exports.deleteTransformRefs = deleteTransformRefs;