"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = exports.ListDataStreamsResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _api_privileges = require("../../constants/api_privileges");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _errors = require("../schema/errors");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListDataStreamsResponseSchema = exports.ListDataStreamsResponseSchema = _configSchema.schema.object({
  data_streams: _configSchema.schema.arrayOf(_configSchema.schema.object({
    index: _configSchema.schema.string(),
    dataset: _configSchema.schema.string(),
    namespace: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    package: _configSchema.schema.string(),
    package_version: _configSchema.schema.string(),
    last_activity_ms: _configSchema.schema.number(),
    size_in_bytes: _configSchema.schema.number(),
    size_in_bytes_formatted: _configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()]),
    dashboards: _configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      title: _configSchema.schema.string()
    })),
    serviceDetails: _configSchema.schema.nullable(_configSchema.schema.object({
      environment: _configSchema.schema.string(),
      serviceName: _configSchema.schema.string()
    }))
  }))
});
const registerRoutes = router => {
  // List of data streams
  router.versioned.get({
    path: _constants2.DATA_STREAM_API_ROUTES.LIST_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL, _api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    },
    summary: `Get data streams`,
    options: {
      tags: ['oas-tag:Data streams']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {},
      response: {
        200: {
          body: () => ListDataStreamsResponseSchema
        },
        400: {
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handlers.getListHandler);
};
exports.registerRoutes = registerRoutes;