"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupTechnologySelector = exports.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../hooks");
var _types = require("../../common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/services/setup_technology_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = exports.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = 'setup-technology-selector';
const SetupTechnologySelector = ({
  disabled,
  allowedSetupTechnologies = [_types.SetupTechnology.AGENT_BASED, _types.SetupTechnology.AGENTLESS],
  setupTechnology,
  onSetupTechnologyChange,
  isAgentlessDefault = false,
  showBetaBadge = true,
  useDescribedFormGroup = true
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const currentSetupTechnology = setupTechnology || (isAgentlessDefault ? _types.SetupTechnology.AGENTLESS : _types.SetupTechnology.AGENT_BASED);
  const agentlessRadioId = `SetupTechnologySelector_${_types.SetupTechnology.AGENTLESS}`;
  const agentBasedRadioId = `SetupTechnologySelector_${_types.SetupTechnology.AGENT_BASED}`;
  const radioGroup = /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: disabled,
    name: "SetupTechnologySelector",
    "data-test-subj": SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ,
    idSelected: `SetupTechnologySelector_${currentSetupTechnology}`,
    options: [{
      id: agentlessRadioId,
      value: _types.SetupTechnology.AGENTLESS,
      disabled: !allowedSetupTechnologies.includes(_types.SetupTechnology.AGENTLESS),
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentlessInputDisplay",
        defaultMessage: "Agentless",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 17
        }
      }), ' ', isAgentlessDefault ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentlessDeployment.recommendedBadge",
        defaultMessage: "Recommended",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 21
        }
      })) : showBetaBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        href: docLinks.links.fleet.agentlessIntegrations,
        target: "_blank",
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.setupTechnology.agentlessDeployment.betaBadge",
          defaultMessage: "Beta",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 85,
            columnNumber: 25
          }
        }),
        size: "s",
        tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.setupTechnology.agentlessDeployment.betaTooltip",
          defaultMessage: "This module is not yet GA. Please help us by reporting any bugs.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 25
          }
        }),
        alignment: "middle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentlessInputDescription",
        defaultMessage: "Set up the integration without an agent",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 15
        }
      }))
    }, {
      id: agentBasedRadioId,
      value: _types.SetupTechnology.AGENT_BASED,
      disabled: !allowedSetupTechnologies.includes(_types.SetupTechnology.AGENT_BASED),
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentbasedInputDisplay",
        defaultMessage: "Agent-based",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentbasedInputDescription",
        defaultMessage: "Deploy an Elastic Agent into your cloud environment",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 19
        }
      }))))
    }],
    onChange: (optionId, value) => {
      var _ref;
      const newSetupTechnology = (_ref = value) !== null && _ref !== void 0 ? _ref : optionId === agentlessRadioId ? _types.SetupTechnology.AGENTLESS : _types.SetupTechnology.AGENT_BASED;
      onSetupTechnologyChange(newSetupTechnology);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  });
  if (useDescribedFormGroup) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.setupTechnologyLabel",
        defaultMessage: "Deployment options",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 13
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.setupTechnologyDescription",
        defaultMessage: "Select a deployment mode for this integration.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 7
      }
    }, radioGroup);
  }

  // Used for security integrations (no form group wrapping)
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.setupTechnology.setupTechnologyLabel",
    defaultMessage: "Deployment options",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }), radioGroup);
};
exports.SetupTechnologySelector = SetupTechnologySelector;