"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstalledIntegrationsActions = useInstalledIntegrationsActions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _hooks = require("../../../../../../../hooks");
var _confirm_bulk_uninstall_modal = require("../components/confirm_bulk_uninstall_modal");
var _confirm_bulk_upgrade_modal = require("../components/confirm_bulk_upgrade_modal");
var _confirm_bulk_rollback_modal = require("../components/confirm_bulk_rollback_modal");
var _use_bulk_actions_context = require("./use_bulk_actions_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/hooks/use_installed_integrations_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useInstalledIntegrationsActions() {
  const {
    upgradingIntegrations,
    uninstallingIntegrations,
    rollingbackIntegrations,
    bulkActions: {
      setPollingBulkActions,
      setActionCompletedCallback
    }
  } = (0, _react.useContext)(_use_bulk_actions_context.bulkActionsContext);
  const queryClient = (0, _reactQuery.useQueryClient)();
  const startServices = (0, _hooks.useStartServices)();
  const {
    notifications: {
      toasts
    }
  } = startServices;
  const bulkUpgradeIntegrations = (0, _react.useCallback)(async (items, updatePolicies) => {
    try {
      const res = await (0, _hooks.sendBulkUpgradePackagesForRq)({
        packages: items.map(item => ({
          name: item.name
        })),
        upgrade_package_policies: updatePolicies
      });
      setPollingBulkActions(actions => [...actions, {
        taskId: res.taskId,
        type: 'bulk_upgrade',
        integrations: items
      }]);
      toasts.addInfo({
        title: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUpgradeInProgressTitle', {
          defaultMessage: 'Upgrade in progress'
        }),
        content: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUpgradeInProgressDescription', {
          defaultMessage: 'The integrations and the policies are upgrading to the latest version.'
        })
      });
      return true;
    } catch (error) {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUpgradeErrorTitle', {
          defaultMessage: 'Error upgrading integrations'
        })
      });
      return false;
    }
  }, [setPollingBulkActions, toasts]);
  const bulkUninstallIntegrations = (0, _react.useCallback)(async items => {
    try {
      if (items.length === 1) {
        await (0, _hooks.sendRemovePackageForRq)({
          pkgName: items[0].name,
          pkgVersion: items[0].installationInfo.version
        });
        await queryClient.invalidateQueries(['get-packages']);
        toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUninstallSuccessTitleSingle', {
            defaultMessage: 'Uninstalled {pkgName}',
            values: {
              pkgName: items[0].name
            }
          })
        });
      } else {
        const res = await (0, _hooks.sendBulkUninstallPackagesForRq)({
          packages: items.map(item => ({
            name: item.name,
            version: item.installationInfo.version
          }))
        });
        setPollingBulkActions(actions => [...actions, {
          taskId: res.taskId,
          type: 'bulk_uninstall',
          integrations: items
        }]);
        toasts.addInfo({
          title: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUninstallInProgressTitle', {
            defaultMessage: 'Uninstall in progress'
          })
        });
      }
      return true;
    } catch (error) {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUninstallErrorTitle', {
          defaultMessage: 'Error uninstalling integrations'
        })
      });
      return false;
    }
  }, [toasts, queryClient, setPollingBulkActions]);
  const bulkRollbackIntegrations = (0, _react.useCallback)(async (items, onActionCompleted) => {
    try {
      setActionCompletedCallback(() => onActionCompleted);
      const res = await (0, _hooks.sendBulkRollbackPackagesForRq)({
        packages: items.map(item => ({
          name: item.name
        }))
      });
      setPollingBulkActions(actions => [...actions, {
        taskId: res.taskId,
        type: 'bulk_rollback',
        integrations: items
      }]);
      toasts.addInfo({
        title: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkRollbackInProgressTitle', {
          defaultMessage: 'Rollback in progress'
        }),
        content: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkRollbackInProgressDescription', {
          defaultMessage: 'Selected integrations and policies are rolling back to the previous version.'
        })
      });
      return true;
    } catch (error) {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkRollbackErrorTitle', {
          defaultMessage: 'Error rolling back integrations'
        })
      });
      return false;
    }
  }, [setPollingBulkActions, toasts, setActionCompletedCallback]);
  const bulkRollbackIntegrationsWithConfirmModal = (0, _react.useCallback)((selectedItems, onActionCompleted) => {
    return new Promise((resolve, reject) => {
      const ref = startServices.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_confirm_bulk_rollback_modal.ConfirmBulkRollbackModal, {
        onClose: () => {
          ref.close();
          resolve('cancelled');
        },
        onConfirm: async () => {
          // Error handled in bulkRollbackIntegrations
          const success = await bulkRollbackIntegrations(selectedItems, onActionCompleted);
          if (success) {
            resolve('confirmed');
          } else {
            throw new Error('rollback integrations failed');
          }
        },
        selectedItems: selectedItems,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 13
        }
      }), startServices));
    });
  }, [startServices, bulkRollbackIntegrations]);
  const bulkUninstallIntegrationsWithConfirmModal = (0, _react.useCallback)(selectedItems => {
    return new Promise((resolve, reject) => {
      const ref = startServices.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_confirm_bulk_uninstall_modal.ConfirmBulkUninstallModal, {
        onClose: () => {
          ref.close();
          resolve();
        },
        onConfirm: async () => {
          // Error handled in bulkUninstallIntegrations
          const success = await bulkUninstallIntegrations(selectedItems);
          if (success) {
            resolve();
          } else {
            throw new Error('uninstall integrations failed');
          }
        },
        selectedItems: selectedItems,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 13
        }
      }), startServices));
    });
  }, [startServices, bulkUninstallIntegrations]);
  const bulkUpgradeIntegrationsWithConfirmModal = (0, _react.useCallback)(selectedItems => {
    return new Promise(resolve => {
      const ref = startServices.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
        client: queryClient,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 265,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_confirm_bulk_upgrade_modal.ConfirmBulkUpgradeModal, {
        onClose: () => {
          ref.close();
          resolve();
        },
        onConfirm: async ({
          updatePolicies
        }) => {
          const success = await bulkUpgradeIntegrations(selectedItems, updatePolicies);
          if (success) {
            resolve();
          } else {
            throw new Error('upgrade integrations failed');
          }
        },
        selectedItems: selectedItems,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 15
        }
      })), startServices));
    });
  }, [startServices, queryClient, bulkUpgradeIntegrations]);
  const actions = (0, _react.useMemo)(() => ({
    bulkUpgradeIntegrationsWithConfirmModal,
    bulkUninstallIntegrationsWithConfirmModal,
    bulkRollbackIntegrationsWithConfirmModal
  }), [bulkUpgradeIntegrationsWithConfirmModal, bulkUninstallIntegrationsWithConfirmModal, bulkRollbackIntegrationsWithConfirmModal]);
  return {
    actions,
    upgradingIntegrations,
    uninstallingIntegrations,
    rollingbackIntegrations
  };
}