"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnchorId = exports.OverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../../../../../common/services");
var _hooks = require("../../../../../../../hooks");
var _services2 = require("../../../../../../../services");
var _side_bar_column = require("../../../components/side_bar_column");
var _components = require("../components");
var _screenshots = require("./screenshots");
var _readme = require("./readme");
var _details = require("./details");
var _requirements = require("./requirements");
var _prerelease_callout = require("./prerelease_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/overview/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SideBar = (0, _styledComponents.default)(_side_bar_column.SideBarColumn)`
  position: sticky;
  top: 70px;
  padding-top: 50px;
  padding-left: 10px;
  text-overflow: ellipsis;
  max-height: 500px;
`;
const StyledSideNav = (0, _styledComponents.default)(_eui.EuiSideNav)`
  overflow-y: auto;
  overflow-x: hidden;
`;
const UnverifiedCallout = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.epm.verificationWarningCalloutTitle', {
      defaultMessage: 'Integration not verified'
    }),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.verificationWarningCalloutIntroText",
    defaultMessage: "This integration contains an unsigned package of unknown authenticity. Learn more about {learnMoreLink}.",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        external: true,
        href: docLinks.links.fleet.packageSignatures,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.verificationWarningCalloutLearnMoreLink",
        defaultMessage: "package signatures",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }));
};
const LogsEssentialsCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "logsEssentialsCallout",
    title: _i18n.i18n.translate('xpack.fleet.epm.logsEssentialsCalloutTitle', {
      defaultMessage: 'As this is a Logs Essentials project, these integrations will only install and configure for logs collection, even if the description mentions metrics.'
    }),
    iconType: "info",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }));
};

// some names are too long so they're trimmed at 12 characters long
const getAnchorId = (name, index) => {
  if (!name) return '';
  const baseId = `${name.replaceAll(' ', '-').toLowerCase().slice(0, 12)}`;
  return index ? `${baseId}-${index}` : baseId;
};
exports.getAnchorId = getAnchorId;
const OverviewPage = exports.OverviewPage = /*#__PURE__*/(0, _react.memo)(({
  packageInfo,
  integrationInfo,
  latestGAVersion
}) => {
  var _config$internal;
  const config = (0, _hooks.useConfig)();
  const screenshots = (0, _react.useMemo)(() => (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.screenshots) || packageInfo.screenshots || [], [integrationInfo, packageInfo.screenshots]);
  const {
    packageVerificationKeyId
  } = (0, _hooks.useGetPackageVerificationKeyId)();
  const isUnverified = (0, _services2.isPackageUnverified)(packageInfo, packageVerificationKeyId);
  const [markdown, setMarkdown] = (0, _react.useState)(undefined);
  const [selectedItemId, setSelectedItem] = (0, _react.useState)(undefined);
  const [isSideNavOpenOnMobile, setIsSideNavOpenOnMobile] = (0, _react.useState)(false);
  const anchorsRefs = (0, _react.useRef)(new Map());
  const selectItem = id => {
    var _anchorsRefs$current$;
    setSelectedItem(id);
    (_anchorsRefs$current$ = anchorsRefs.current.get(id)) === null || _anchorsRefs$current$ === void 0 ? void 0 : _anchorsRefs$current$.scrollIntoView({
      behavior: 'smooth'
    });
  };
  const toggleOpenOnMobile = () => {
    setIsSideNavOpenOnMobile(!isSideNavOpenOnMobile);
  };
  const readmePath = integrationInfo && (0, _services.isIntegrationPolicyTemplate)(integrationInfo) && integrationInfo !== null && integrationInfo !== void 0 && integrationInfo.readme ? integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.readme : packageInfo.readme || '';
  (0, _react.useEffect)(() => {
    (0, _hooks.sendGetFileByPath)(readmePath).then(res => {
      setMarkdown(res.data || '');
    });
  }, [readmePath]);
  const extractHeadingsWithIndices = markDown => {
    if (!markDown) return [];
    const regex = /^\s*#+\s+(.+)/;
    return markDown.split('\n').map((line, position) => {
      return {
        line,
        position
      };
    }).filter(obj => obj.line.match(regex));
  };
  const getName = heading => heading.replace(/^#+\s*/, '');
  const createItem = (0, _react.useCallback)((heading, options = {}) => {
    // NOTE: Duplicate `name` values will cause `id` collisions
    const name = getName(heading.line);
    const id = getAnchorId(name, heading.position + 1);
    return {
      id,
      name,
      isSelected: selectedItemId === id,
      onClick: () => selectItem(id),
      ...options,
      // skip rendering empty items while preserving the header hierarchy
      renderItem: name === '' ? () => null : undefined
    };
  }, [selectedItemId]);

  // get the headings and creates a nested structure as requested by EuiSideNav
  const headingsToNavItems = (0, _react.useCallback)(headings => {
    const options = {
      forceOpen: true
    };
    return headings.reduce((acc, heading, index) => {
      if (heading.line.startsWith('## ')) {
        const item = createItem(heading, options);
        acc.push(item);
      } else if (heading.line.startsWith('### ')) {
        const subGroup = createItem(heading, options);
        let i = index + 1;
        while (i < headings.length && headings[i].line.startsWith('#### ')) {
          var _subGroup$items;
          const subGroupItem = createItem(headings[i], options);
          if (!(subGroup !== null && subGroup !== void 0 && subGroup.items)) subGroup.items = [];
          (_subGroup$items = subGroup.items) === null || _subGroup$items === void 0 ? void 0 : _subGroup$items.push(subGroupItem);
          i++;
        }
        const prevIndex = acc.length - 1;
        if (prevIndex >= 0) {
          var _acc$prevIndex, _acc$prevIndex2, _acc$prevIndex2$items;
          if (!((_acc$prevIndex = acc[prevIndex]) !== null && _acc$prevIndex !== void 0 && _acc$prevIndex.items)) acc[prevIndex].items = [];
          (_acc$prevIndex2 = acc[prevIndex]) === null || _acc$prevIndex2 === void 0 ? void 0 : (_acc$prevIndex2$items = _acc$prevIndex2.items) === null || _acc$prevIndex2$items === void 0 ? void 0 : _acc$prevIndex2$items.push(subGroup);
        } else {
          var _acc$, _acc$2, _acc$2$items;
          // this handles a case where the headings only have ### and no ##
          const fakeItem = createItem({
            line: '',
            position: heading.position
          }, options);
          acc.push(fakeItem);
          if (!((_acc$ = acc[0]) !== null && _acc$ !== void 0 && _acc$.items)) acc[0].items = [];
          (_acc$2 = acc[0]) === null || _acc$2 === void 0 ? void 0 : (_acc$2$items = _acc$2.items) === null || _acc$2$items === void 0 ? void 0 : _acc$2$items.push(subGroup);
        }
      }
      return acc;
    }, []);
  }, [createItem]);
  const headingsWithIndices = (0, _react.useMemo)(() => extractHeadingsWithIndices(markdown), [markdown]);
  const navItems = (0, _react.useMemo)(() => headingsToNavItems(headingsWithIndices), [headingsToNavItems, headingsWithIndices]);
  const h1 = (0, _react.useMemo)(() => headingsWithIndices.find(h => h.line.startsWith('# ')), [headingsWithIndices]);
  const sideNavItems = (0, _react.useMemo)(() => {
    const name = `${h1 ? getName(h1.line) : ''}`;
    const id = getAnchorId(name, h1 ? (h1 === null || h1 === void 0 ? void 0 : h1.position) + 1 : 1);
    return [{
      name,
      id,
      onClick: () => selectItem(id),
      items: navItems
    }];
  }, [h1, navItems]);
  const requireAgentRootPrivileges = (0, _services.isRootPrivilegesRequired)(packageInfo);
  const hideDashboards = config === null || config === void 0 ? void 0 : config.hideDashboards;
  const showLogsEssentialsCallout = (0, _lodash.isEqual)(config === null || config === void 0 ? void 0 : (_config$internal = config.internal) === null || _config$internal === void 0 ? void 0 : _config$internal.excludeDataStreamTypes, ['metrics']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    "data-test-subj": "epm.OverviewPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SideBar, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }, sideNavItems ? /*#__PURE__*/_react.default.createElement(StyledSideNav, {
    mobileTitle: "Nav Items",
    toggleOpenOnMobile: toggleOpenOnMobile,
    isOpenOnMobile: isSideNavOpenOnMobile,
    items: sideNavItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 13
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 9
    }
  }, isUnverified && /*#__PURE__*/_react.default.createElement(UnverifiedCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 28
    }
  }), showLogsEssentialsCallout && /*#__PURE__*/_react.default.createElement(LogsEssentialsCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 41
    }
  }), /*#__PURE__*/_react.default.createElement(_components.BidirectionalIntegrationsBanner, {
    integrationPackageName: packageInfo.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_components.CloudPostureThirdPartySupportCallout, {
    packageInfo: packageInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_prerelease_callout.PrereleaseCallout, {
    packageInfo: packageInfo,
    latestGAVersion: latestGAVersion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 11
    }
  }), packageInfo.readme ? /*#__PURE__*/_react.default.createElement(_readme.Readme, {
    markdown: markdown,
    packageName: packageInfo.name,
    version: packageInfo.version,
    refs: anchorsRefs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 13
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 11
    }
  }, requireAgentRootPrivileges ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_requirements.Requirements, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 17
    }
  })) : null, !hideDashboards && screenshots.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_screenshots.Screenshots, {
    images: screenshots,
    packageName: packageInfo.name,
    version: packageInfo.version,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 17
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_details.Details, {
    packageInfo: packageInfo,
    integrationInfo: integrationInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 15
    }
  })))));
});