"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputHealth = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/output_health.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REFRESH_INTERVAL_MS = 10000;
const OutputHealth = ({
  output,
  showBadge
}) => {
  var _output$hosts$join, _output$hosts;
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [outputHealth, setOutputHealth] = (0, _react.useState)();
  const {
    data: outputHealthResponse
  } = (0, _reactQuery.useQuery)(['outputHealth', output.id], () => (0, _hooks.sendGetOutputHealth)(output.id), {
    refetchInterval: REFRESH_INTERVAL_MS
  });
  (0, _react.useEffect)(() => {
    if (outputHealthResponse !== null && outputHealthResponse !== void 0 && outputHealthResponse.error) {
      notifications.toasts.addError(outputHealthResponse === null || outputHealthResponse === void 0 ? void 0 : outputHealthResponse.error, {
        title: _i18n.i18n.translate('xpack.fleet.output.errorFetchingOutputHealth', {
          defaultMessage: 'Error fetching output state'
        })
      });
    }
    setOutputHealth(outputHealthResponse === null || outputHealthResponse === void 0 ? void 0 : outputHealthResponse.data);
  }, [outputHealthResponse, notifications.toasts]);
  const EditOutputStatus = {
    DEGRADED: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Error",
      color: "danger",
      iconType: "error",
      "data-test-subj": "outputHealthDegradedCallout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      className: "eui-textBreakWord",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.fleet.output.calloutText', {
      defaultMessage: 'Unable to connect to "{name}" at {host}.',
      values: {
        name: output.name,
        host: (_output$hosts$join = (_output$hosts = output.hosts) === null || _output$hosts === void 0 ? void 0 : _output$hosts.join(',')) !== null && _output$hosts$join !== void 0 ? _output$hosts$join : ''
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.fleet.output.calloutPromptText', {
      defaultMessage: 'Please check the details are correct.'
    }))),
    HEALTHY: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Healthy",
      color: "success",
      iconType: "check",
      "data-test-subj": "outputHealthHealthyCallout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.fleet.output.successCalloutText', {
      defaultMessage: 'Connection with remote output established.'
    })))
  };
  const OutputStatusBadge = {
    DEGRADED: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      "data-test-subj": "outputHealthDegradedBadge",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.outputHealth.degradedStatusText",
      defaultMessage: "Unhealthy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    })),
    HEALTHY: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success",
      "data-test-subj": "outputHealthHealthyBadge",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.outputHealth.healthyStatusText",
      defaultMessage: "Healthy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }))
  };
  const msLastTimestamp = new Date((outputHealth === null || outputHealth === void 0 ? void 0 : outputHealth.timestamp) || 0).getTime();
  const lastTimestampText = msLastTimestamp ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.outputHealth.timestampTooltipText",
    defaultMessage: "Last reported {timestamp}",
    values: {
      timestamp: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        value: msLastTimestamp,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 22
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  })) : null;
  const outputBadge = (outputHealth === null || outputHealth === void 0 ? void 0 : outputHealth.state) && OutputStatusBadge[outputHealth === null || outputHealth === void 0 ? void 0 : outputHealth.state] || null;
  return showBadge ? lastTimestampText && outputHealth !== null && outputHealth !== void 0 && outputHealth.state ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: lastTimestampText,
    "data-test-subj": "outputHealthBadgeTooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, outputBadge, " ")) : outputBadge : (outputHealth === null || outputHealth === void 0 ? void 0 : outputHealth.state) && EditOutputStatus[outputHealth.state] || null;
};
exports.OutputHealth = OutputHealth;