"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMissingEncryptionKeyCallout = void 0;
var _react = require("react");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_KEY = 'fleet.missingEncryptionKeyCalloutHasBeenDismissed';
const useMissingEncryptionKeyCallout = () => {
  const {
    missingOptionalFeatures
  } = (0, _hooks.useFleetStatus)();
  const {
    storage
  } = (0, _hooks.useStartServices)();
  const [isCalloutDismissed, setIsCalloutDismissed] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const storageValue = storage.get(LOCAL_STORAGE_KEY);
    if (storageValue) {
      setIsCalloutDismissed(Boolean(storageValue));
    }
  }, [storage]);
  const canShowMissingEncryptionKeyCallout = (0, _react.useMemo)(() => {
    if (isCalloutDismissed || !missingOptionalFeatures) {
      return false;
    }
    return missingOptionalFeatures.includes('encrypted_saved_object_encryption_key_required');
  }, [missingOptionalFeatures, isCalloutDismissed]);
  const dismissEncryptionKeyCallout = (0, _react.useCallback)(() => {
    storage.set(LOCAL_STORAGE_KEY, 'true');
    setIsCalloutDismissed(true);
  }, [storage]);
  return [canShowMissingEncryptionKeyCallout, dismissEncryptionKeyCallout];
};
exports.useMissingEncryptionKeyCallout = useMissingEncryptionKeyCallout;