"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderRightContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _components = require("../../../components");
var _components2 = require("../../../../../components");
var _constants = require("../../../../../../../../common/constants");
var _services = require("../../../../../../../../common/services");
var _manage_auto_upgrade_agents_modal = require("../../../../agents/components/manage_auto_upgrade_agents_modal");
var _auto_upgrade_agents_tour = require("../../../components/auto_upgrade_agents_tour");
var _use_can_enable_auto_upgrades = require("../../../../../../../hooks/use_can_enable_auto_upgrades");
var _manage_auto_upgrade_agents = require("./manage_auto_upgrade_agents");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/details_page/components/header/right_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Divider = _styledComponents.default.div`
  width: 0;
  height: 100%;
  border-left: ${props => props.theme.eui.euiBorderThin};
`;
const HeaderRightContent = ({
  isLoading,
  agentPolicy,
  addAgent,
  onCancelEnrollment,
  isAddAgentHelpPopoverOpen,
  setIsAddAgentHelpPopoverOpen
}) => {
  var _agentPolicy$revision;
  const authz = (0, _hooks.useAuthz)();
  const {
    getPath
  } = (0, _hooks.useLink)();
  const history = (0, _reactRouterDom.useHistory)();
  const [isManageAutoUpgradeAgentsModalOpen, setIsManageAutoUpgradeAgentsModalOpen] = (0, _react.useState)(false);
  const refreshAgentPolicy = (0, _hooks.useAgentPolicyRefresh)();
  const canEnableAutomaticAgentUpgrades = (0, _use_can_enable_auto_upgrades.useCanEnableAutomaticAgentUpgrades)();
  const isFleetServerPolicy = (0, _react.useMemo)(() => {
    var _agentPolicy$package_;
    return agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$package_ = agentPolicy.package_policies) === null || _agentPolicy$package_ === void 0 ? void 0 : _agentPolicy$package_.some(packagePolicy => {
      var _packagePolicy$packag;
      return ((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === _constants.FLEET_SERVER_PACKAGE;
    });
  }, [agentPolicy]);
  if (!agentPolicy) {
    return null;
  }
  const addFleetServerLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: addAgent,
    "data-test-subj": "addAgentLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.addFleetServerButton",
    defaultMessage: "Add Fleet Server",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }));
  const addAgentLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: addAgent,
    "data-test-subj": "addAgentLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.addAgentButton",
    defaultMessage: "Add agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'flexEnd',
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, isLoading || !agentPolicy ? null : [{
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.revision', {
      defaultMessage: 'Revision'
    }),
    content: (_agentPolicy$revision = agentPolicy.revision) !== null && _agentPolicy$revision !== void 0 ? _agentPolicy$revision : 0
  }, {
    isDivider: true
  }, {
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.integrations', {
      defaultMessage: 'Integrations'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: agentPolicy.package_policies && agentPolicy.package_policies.length || 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 19
      }
    })
  }, {
    isDivider: true
  }, ...(authz.fleet.readAgents && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless) ? [{
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.usedBy', {
      defaultMessage: 'Agents'
    }),
    content: !agentPolicy.agents && isFleetServerPolicy && authz.fleet.addFleetServers ? /*#__PURE__*/_react.default.createElement(_components2.AddAgentHelpPopover, {
      button: addFleetServerLink,
      isOpen: isAddAgentHelpPopoverOpen,
      offset: 15,
      closePopover: () => {
        setIsAddAgentHelpPopoverOpen(false);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 27
      }
    }) : !agentPolicy.agents && !isFleetServerPolicy && authz.fleet.addAgents ? /*#__PURE__*/_react.default.createElement(_components2.AddAgentHelpPopover, {
      button: addAgentLink,
      isOpen: isAddAgentHelpPopoverOpen,
      offset: 15,
      closePopover: () => {
        setIsAddAgentHelpPopoverOpen(false);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 27
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 29
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 35
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 37
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.summary.usedByUnprivilegedTooltip",
        defaultMessage: "{count, plural, one {# unprivileged agent} other {# unprivileged agents}}",
        values: {
          count: agentPolicy.unprivileged_agents || 0
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 39
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 37
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.summary.usedByPrivilegedTooltip",
        defaultMessage: "{count, plural, one {# privileged agent} other {# privileged agents}}",
        values: {
          count: (agentPolicy.agents || 0) - (agentPolicy.unprivileged_agents || 0)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 39
        }
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 31
      }
    }, /*#__PURE__*/_react.default.createElement(_components.LinkedAgentCount, {
      count: agentPolicy.agents || 0,
      agentPolicyId: agentPolicy.id,
      showAgentText: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 33
      }
    }))), (0, _services.getRootIntegrations)(agentPolicy.package_policies || []).length > 0 && (agentPolicy.unprivileged_agents || 0) > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 33
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "warning",
      color: "warning",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.summary.containsUnprivilegedAgentsWarning",
        defaultMessage: "This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 39
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 35
      }
    })))
  }, {
    isDivider: true
  }] : []), {
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.lastUpdated', {
      defaultMessage: 'Last updated on'
    }),
    content: agentPolicy && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.updated_at,
      year: "numeric",
      month: "short",
      day: "2-digit",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 21
      }
    }) || ''
  }, {
    isDivider: true
  }, ...(canEnableAutomaticAgentUpgrades && authz.fleet.allAgentPolicies && authz.fleet.allAgents && !agentPolicy.is_managed ? [{
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.autoUpgrade', {
      defaultMessage: 'Auto-upgrade agents'
    }),
    content: /*#__PURE__*/_react.default.createElement(_manage_auto_upgrade_agents.ManageAutoUpgradeAgentsBadge, {
      agentPolicy: agentPolicy,
      isManageAutoUpgradeAgentsModalOpen: isManageAutoUpgradeAgentsModalOpen,
      setIsManageAutoUpgradeAgentsModalOpen: setIsManageAutoUpgradeAgentsModalOpen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 25
      }
    })
  }, {
    isDivider: true
  }] : []), {
    content: agentPolicy && /*#__PURE__*/_react.default.createElement(_components.AgentPolicyActionMenu, {
      agentPolicy: agentPolicy,
      fullButton: true,
      onCopySuccess: newAgentPolicy => {
        history.push(getPath('policy_details', {
          policyId: newAgentPolicy.id
        }));
      },
      onCancelEnrollment: onCancelEnrollment,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 19
      }
    })
  }].map((item, index) => {
    var _item$isDivider;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 15
      }
    }, ((_item$isDivider = item.isDivider) !== null && _item$isDivider !== void 0 ? _item$isDivider : false) ? /*#__PURE__*/_react.default.createElement(Divider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 19
      }
    }) : item.label ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      textStyle: "reverse",
      css: {
        textAlign: 'right'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      className: "eui-textNoWrap",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 21
      }
    }, item.label), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textNoWrap",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 21
      }
    }, item.content)) : item.content);
  })), isManageAutoUpgradeAgentsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_manage_auto_upgrade_agents_modal.ManageAutoUpgradeAgentsModal, {
    agentPolicy: agentPolicy,
    agentCount: agentPolicy.agents || 0,
    onClose: refreshPolicy => {
      setIsManageAutoUpgradeAgentsModalOpen(false);
      if (refreshPolicy) {
        refreshAgentPolicy();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 11
    }
  })), canEnableAutomaticAgentUpgrades ? /*#__PURE__*/_react.default.createElement(_auto_upgrade_agents_tour.AutoUpgradeAgentsTour, {
    anchor: "#auto-upgrade-manage-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 9
    }
  }) : null);
};
exports.HeaderRightContent = HeaderRightContent;